/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.entity.util;

import dev.itsmeow.whisperwoods.imdlib.entity.AbstractEntityBuilder;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeDefinition;
import dev.itsmeow.whisperwoods.imdlib.item.IContainerItem;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;

public class EntityTypeContainerContainable<T extends Mob, I extends Item>
extends EntityTypeContainer<T> {
    protected EntityDataAccessor<Boolean> fromContainerDataKey;
    protected I containerItem;
    protected Item emptyContainerItem;
    protected String containerItemName;
    protected String emptyContainerItemName;

    protected EntityTypeContainerContainable(ContainableEntityTypeDefinition<T, I, EntityTypeContainerContainable<T, I>> def) {
        super(def);
        this.containerItem = (Item)def.getContainerSupplier().apply(this, def.getTooltipFunction());
        this.emptyContainerItem = def.getEmptyContainerSupplier().apply(this);
        this.containerItemName = def.getContainerNameSupplier().apply(this);
        this.emptyContainerItemName = def.getEmptyContainerNameSupplier().apply(this);
    }

    public EntityDataAccessor<Boolean> getFromContainerDataKey() {
        if (this.fromContainerDataKey == null) {
            this.fromContainerDataKey = SynchedEntityData.m_135353_(this.getEntityClass(), (EntityDataSerializer)EntityDataSerializers.f_135035_);
        }
        return this.fromContainerDataKey;
    }

    public I getContainerItem() {
        return this.containerItem;
    }

    public Item getEmptyContainerItem() {
        return this.emptyContainerItem;
    }

    public String getEmptyContainerItemName() {
        return this.emptyContainerItemName;
    }

    public String getContainerItemName() {
        return this.containerItemName;
    }

    protected static class ContainableEntityTypeDefinition<T extends Mob, I extends Item, C extends EntityTypeContainerContainable<T, I>>
    extends EntityTypeDefinition<T> {
        AbstractEntityBuilderContainable<T, I, C, ?> builder;

        public ContainableEntityTypeDefinition(AbstractEntityBuilderContainable<T, I, C, ?> builder) {
            super(builder);
            this.builder = builder;
        }

        public IContainerItem.ITooltipFunction getTooltipFunction() {
            return this.builder.tooltipFinal;
        }

        public BiFunction<C, IContainerItem.ITooltipFunction, I> getContainerSupplier() {
            return this.builder.containerSupplier;
        }

        public Function<C, Item> getEmptyContainerSupplier() {
            return this.builder.emptyContainerSupplier;
        }

        public Function<C, String> getContainerNameSupplier() {
            return this.builder.containerNameSupplier;
        }

        public Function<C, String> getEmptyContainerNameSupplier() {
            return this.builder.emptyContainerNameSupplier;
        }
    }

    public static class Builder<T extends Mob, I extends Item>
    extends AbstractEntityBuilderContainable<T, I, EntityTypeContainerContainable<T, I>, Builder<T, I>> {
        protected Builder(Class<T> EntityClass, EntityType.EntityFactory<T> factory, String entityNameIn, Supplier<AttributeSupplier.Builder> attributeMap, String modid) {
            super(EntityClass, factory, entityNameIn, attributeMap, modid);
        }

        public static <T extends Mob, I extends Item> Builder<T, I> create(Class<T> EntityClass, EntityType.EntityFactory<T> factory, String entityNameIn, Supplier<AttributeSupplier.Builder> attributeMap, String modid) {
            return new Builder<T, I>(EntityClass, factory, entityNameIn, attributeMap, modid);
        }

        @Override
        public EntityTypeContainerContainable<T, I> rawBuild() {
            return new EntityTypeContainerContainable(new ContainableEntityTypeDefinition(this));
        }

        @Override
        public Builder<T, I> getImplementation() {
            return this;
        }
    }

    public static abstract class AbstractEntityBuilderContainable<T extends Mob, I extends Item, C extends EntityTypeContainerContainable<T, I>, B extends AbstractEntityBuilderContainable<T, I, C, B>>
    extends AbstractEntityBuilder<T, C, B> {
        protected IContainerItem.ITooltipFunction tooltip;
        protected IContainerItem.ITooltipFunction tooltipFinal;
        protected BiFunction<C, IContainerItem.ITooltipFunction, I> containerSupplier;
        protected Function<C, Item> emptyContainerSupplier;
        protected Function<C, String> containerNameSupplier;
        protected Function<C, String> emptyContainerNameSupplier;

        protected AbstractEntityBuilderContainable(Class<T> EntityClass, EntityType.EntityFactory<T> factory, String entityNameIn, Supplier<AttributeSupplier.Builder> attributeMap, String modid) {
            super(EntityClass, factory, entityNameIn, attributeMap, modid);
        }

        public B containers(String containerNameFormat, BiFunction<C, IContainerItem.ITooltipFunction, I> containerSupplier, String emptyContainerNameFormat, Function<C, Item> emptyContainerSupplier) {
            return this.containers(containerNameFormat, containerSupplier, emptyContainerNameFormat, emptyContainerSupplier, null);
        }

        public B containers(String containerNameFormat, BiFunction<C, IContainerItem.ITooltipFunction, I> containerSupplier, String emptyContainerNameFormat, Function<C, Item> emptyContainerSupplier, IContainerItem.ITooltipFunction tooltip) {
            this.containerSupplier = containerSupplier;
            this.emptyContainerSupplier = emptyContainerSupplier;
            this.tooltip = tooltip;
            this.containerNameSupplier = c -> String.format(containerNameFormat, c.getEntityName());
            this.emptyContainerNameSupplier = c -> String.format(emptyContainerNameFormat, c.getEntityName());
            return (B)((AbstractEntityBuilderContainable)this.getImplementation());
        }

        @Override
        public void preBuild() {
            this.tooltipFinal = this.variantCount > 0 ? (this.tooltip == null ? IContainerItem.VARIANT_TOOLTIP : (container, stack, worldIn, tooltip) -> {
                IContainerItem.VARIANT_TOOLTIP.addInformation(container, stack, worldIn, tooltip);
                this.tooltip.addInformation(container, stack, worldIn, tooltip);
            }) : (this.tooltip != null ? this.tooltip : (container, stack, world, tooltip) -> {});
        }
    }
}

