/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.item;

import dev.itsmeow.whisperwoods.imdlib.block.AnimalSkullBlock;
import dev.itsmeow.whisperwoods.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.whisperwoods.imdlib.util.HeadType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ItemBlockSkull
extends StandingAndWallBlockItem {
    public final HeadType.PlacementType placement;
    public final String id;
    public final IVariant variant;

    public ItemBlockSkull(Block block, HeadType.PlacementType placement, String id, IVariant variant, CreativeModeTab group) {
        super(block, block, new Item.Properties().m_41491_(group));
        this.placement = placement;
        this.id = id;
        this.variant = variant;
    }

    public ItemBlockSkull(Block block, HeadType.PlacementType placement, String id, IVariant variant, Item.Properties prop) {
        super(block, block, prop);
        this.placement = placement;
        this.id = id;
        this.variant = variant;
    }

    @Nullable
    protected BlockState m_5965_(BlockPlaceContext ctx) {
        BlockState returnedState = null;
        Level world = ctx.m_43725_();
        BlockPos clickPos = ctx.m_8083_();
        for (Direction side : ctx.m_6232_()) {
            if (side == Direction.DOWN && this.placement != HeadType.PlacementType.FLOOR_AND_WALL) {
                return null;
            }
            BlockState newState = this.m_40614_().m_5573_(ctx);
            if (newState == null || !newState.m_60710_((LevelReader)world, clickPos) || newState.m_61143_((Property)AnimalSkullBlock.FACING_EXCEPT_DOWN) == Direction.UP && this.placement != HeadType.PlacementType.FLOOR_AND_WALL) continue;
            returnedState = newState;
            break;
        }
        return returnedState;
    }

    public InteractionResult m_40576_(BlockPlaceContext ctx) {
        if (!ctx.m_7059_()) {
            return InteractionResult.FAIL;
        }
        if (ctx.m_7820_() == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        BlockState placementState = this.m_5965_(ctx);
        if (placementState == null) {
            return InteractionResult.FAIL;
        }
        if (!this.m_7429_(ctx, placementState)) {
            return InteractionResult.FAIL;
        }
        if (ctx.m_7820_() == Direction.UP && this.placement != HeadType.PlacementType.FLOOR_AND_WALL) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = ctx.m_8083_();
        Level world = ctx.m_43725_();
        Player player = ctx.m_43723_();
        ItemStack stack = ctx.m_43722_();
        BlockState newState = world.m_8055_(blockpos);
        Block block = newState.m_60734_();
        if (block == placementState.m_60734_()) {
            this.m_7274_(blockpos, world, player, stack, newState);
            block.m_6402_(world, blockpos, newState, (LivingEntity)player, stack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, blockpos, stack);
            }
        }
        SoundType soundtype = newState.m_60827_();
        world.m_5594_(player, blockpos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        stack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }
}

