/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.item;

import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.whisperwoods.imdlib.item.IContainerItem;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemModEntityContainer<T extends Mob>
extends Item
implements IContainerItem<T> {
    protected final EntityTypeContainerContainable<T, ItemModEntityContainer<T>> typeContainer;
    protected final IContainerItem.ITooltipFunction tooltip;

    public ItemModEntityContainer(EntityTypeContainerContainable<T, ItemModEntityContainer<T>> typeContainer, CreativeModeTab group) {
        this(typeContainer, IContainerItem.VARIANT_TOOLTIP, group);
    }

    public ItemModEntityContainer(EntityTypeContainerContainable<T, ItemModEntityContainer<T>> typeContainer, IContainerItem.ITooltipFunction tooltip, CreativeModeTab group) {
        super(new Item.Properties().m_41487_(1).m_41491_(group));
        this.typeContainer = typeContainer;
        this.tooltip = tooltip;
    }

    public static <T extends Mob> BiFunction<EntityTypeContainerContainable<T, ItemModEntityContainer<T>>, IContainerItem.ITooltipFunction, ItemModEntityContainer<T>> get(CreativeModeTab group) {
        return (container, tooltip) -> new ItemModEntityContainer(container, (IContainerItem.ITooltipFunction)tooltip, group);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!worldIn.f_46443_) {
            ItemStack itemstack = playerIn.m_21120_(handIn);
            BlockHitResult raytraceresult = ItemModEntityContainer.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (raytraceresult.m_6662_() == HitResult.Type.MISS) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
            }
            if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
            }
            BlockPos blockpos = raytraceresult.m_82425_();
            if (worldIn instanceof ServerLevel) {
                this.placeEntity((ServerLevel)worldIn, playerIn.m_21120_(handIn), blockpos.m_142300_(raytraceresult.m_82434_()));
            }
            if (!playerIn.m_7500_()) {
                playerIn.m_8061_(handIn == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, new ItemStack((ItemLike)this.typeContainer.getEmptyContainerItem()));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        if (list != null) {
            this.tooltip.addInformation(this.typeContainer, stack, level, list);
        }
    }

    @Override
    public EntityTypeContainer<T> getContainer() {
        return this.typeContainer;
    }
}

