/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.blockentity;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.mojang.math.Vector3f;
import dev.architectury.registry.registries.Registries;
import dev.itsmeow.whisperwoods.block.GhostLightBlock;
import dev.itsmeow.whisperwoods.block.HandOfFateBlock;
import dev.itsmeow.whisperwoods.entity.EntityWisp;
import dev.itsmeow.whisperwoods.init.ModBlockEntities;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.network.HOFEffectPacket;
import dev.itsmeow.whisperwoods.network.WWNetwork;
import dev.itsmeow.whisperwoods.util.TaskQueue;
import dev.itsmeow.whisperwoods.util.WispColors;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;

public class HandOfFateBlockEntity
extends BlockEntity {
    public static final ImmutableBiMap<String, HOFRecipe> RECIPES = ImmutableBiMap.of((Object)"hirschgeist", (Object)new HOFRecipe(ChatFormatting.AQUA, true, Items.f_42500_, Items.f_42415_, Items.f_42049_), (Object)"wisp", (Object)new HOFRecipe(ChatFormatting.GOLD, false, Items.f_42593_, Items.f_42525_, Items.f_42049_));
    private final CurrentRecipeContainer recipeContainer = new CurrentRecipeContainer();
    private Item toDisplay = null;
    boolean displayDirty = true;
    public float lastAnimationY = 0.0f;

    public HandOfFateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.HAND_OF_FATE.get(), pos, state);
    }

    public Item getDisplayItem() {
        if (this.displayDirty) {
            this.toDisplay = this.getRecipeContainer().getDisplayItem();
            this.displayDirty = false;
        }
        return this.toDisplay;
    }

    public void m_6596_() {
        super.m_6596_();
        this.sync();
    }

    public void sync() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public boolean isLit() {
        Block b = this.m_58900_().m_60734_();
        if (b instanceof HandOfFateBlock && this.m_58898_()) {
            HandOfFateBlock block = (HandOfFateBlock)b;
            return block.isLit(this.m_58904_(), this.m_58899_());
        }
        return false;
    }

    public boolean hasBlaze() {
        return this.recipeContainer.hasItemInRecipe(Items.f_42593_);
    }

    public CurrentRecipeContainer getRecipeContainer() {
        return this.recipeContainer;
    }

    protected void playSound(SoundEvent sound, float vol, float pitch) {
        if (this.m_58898_()) {
            this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), sound, SoundSource.BLOCKS, vol, pitch);
        }
    }

    protected void sendToTrackers(HOFEffectPacket pkt) {
        if (this.m_58898_()) {
            WWNetwork.HANDLER.sendToPlayers((Iterable)((ServerChunkCache)this.m_58904_().m_7726_()).f_8325_.m_183262_(new ChunkPos(this.f_58858_), false), (Object)pkt);
        }
    }

    public static <T extends HandOfFateBlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (level.m_46467_() % 5L == 0L) {
            List items = level.m_45976_(ItemEntity.class, state.m_60816_((BlockGetter)level, pos).m_83215_().m_82338_(pos).m_82400_(0.25));
            for (ItemEntity item : items) {
                ItemStack stack;
                if (!item.m_6084_() || (stack = item.m_32055_()).m_41613_() <= 0) continue;
                InteractionResult r = blockEntity.reactToItem(stack, state, level, pos);
                if (r == InteractionResult.CONSUME) {
                    item.m_32055_().m_41774_(1);
                    blockEntity.playSound(SoundEvents.f_11859_, 1.0f, 1.0f);
                    blockEntity.displayDirty = true;
                    if (item.m_32055_().m_41613_() == 0) {
                        item.m_146870_();
                    }
                    blockEntity.m_6596_();
                    break;
                }
                if (!(stack.m_41720_() instanceof BlockItem) || !level.m_46859_(pos.m_7494_())) continue;
                BlockItem i = (BlockItem)stack.m_41720_();
                if (i.m_40614_() instanceof GhostLightBlock) {
                    item.m_32055_().m_41774_(1);
                    blockEntity.playSound(SoundEvents.f_11859_, 1.0f, 1.0f);
                    level.m_46597_(pos.m_7494_(), i.m_40614_().m_49966_());
                }
                if (item.m_32055_().m_41613_() != 0) break;
                item.m_146870_();
                break;
            }
        }
    }

    public InteractionResult onBlockActivated(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult r = this.reactToItem(player.m_21120_(hand), state, worldIn, pos);
        if (r == InteractionResult.CONSUME) {
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            this.playSound(SoundEvents.f_11859_, 1.0f, 1.0f);
            this.displayDirty = true;
            this.m_6596_();
        }
        return r;
    }

    public InteractionResult reactToItem(ItemStack stack, BlockState state, Level worldIn, BlockPos pos) {
        boolean lit;
        boolean bl = lit = this.isLit() || this.hasBlaze();
        if (lit || stack.m_41720_() == Items.f_42593_) {
            if (!this.getRecipeContainer().hasRecipe()) {
                for (HOFRecipe recipe : RECIPES.values()) {
                    if (!recipe.isFirst(stack.m_41720_())) continue;
                    this.getRecipeContainer().setRecipe(recipe);
                    if (!this.getRecipeContainer().checkedAdd(stack.m_41720_())) continue;
                    return InteractionResult.CONSUME;
                }
            } else if (this.getRecipeContainer().checkedAdd(stack.m_41720_())) {
                if (this.getRecipeContainer().isRecipeComplete()) {
                    this.onRecipeComplete(this.getRecipeContainer().getCurrentRecipe(), state, worldIn, pos);
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void onRecipeComplete(HOFRecipe recipe, BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn instanceof ServerLevel && !worldIn.f_46443_) {
            ServerLevel world = (ServerLevel)worldIn;
            switch (recipe.getName()) {
                case "hirschgeist": {
                    HOFEffectPacket hgpk = new HOFEffectPacket(HOFEffectPacket.HOFEffectType.HIRSCHGEIST, new Vector3f((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 1.0f, (float)pos.m_123343_() + 0.5f), WispColors.BLUE.getColor());
                    this.sendToTrackers(hgpk);
                    this.playSound(SoundEvents.f_11862_, 1.0f, 1.0f);
                    this.playSound(SoundEvents.f_11700_, 1.0f, 1.0f);
                    TaskQueue.QUEUE_SERVER.schedule(50, () -> ModEntities.HIRSCHGEIST.getEntityType().m_20592_((ServerLevel)worldIn, null, null, pos.m_7494_(), MobSpawnType.EVENT, false, false));
                    break;
                }
                case "wisp": {
                    EntityWisp wisp = (EntityWisp)ModEntities.WISP.getEntityType().m_20615_((Level)world);
                    Block above = world.m_8055_(pos.m_7494_()).m_60734_();
                    WispColors.WispColor wColor = above instanceof GhostLightBlock ? WispColors.byColor(((GhostLightBlock)above).getColor()) : WispColors.values()[wisp.m_21187_().nextInt(WispColors.values().length)];
                    wisp.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5);
                    double d0 = 1.0 + Shapes.m_193135_((Direction.Axis)Direction.Axis.Y, (AABB)wisp.m_142469_(), (Iterable)world.m_186431_(null, new AABB(pos)), (double)-1.0);
                    wisp.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + d0, (double)pos.m_123343_() + 0.5, Mth.m_14177_((float)(world.f_46441_.nextFloat() * 360.0f)), 0.0f);
                    wisp.f_20885_ = wisp.m_146908_();
                    wisp.f_20883_ = wisp.m_146908_();
                    wisp.isHostile = wisp.getNewHostileChance();
                    wisp.m_20088_().m_135381_(EntityWisp.COLOR_VARIANT, (Object)(wColor.ordinal() + 1));
                    worldIn.m_7967_((Entity)wisp);
                    int color = wisp.getWispColor().getColor();
                    HOFEffectPacket packet = new HOFEffectPacket(HOFEffectPacket.HOFEffectType.CIRCLE, new Vector3f((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 1.0f, (float)pos.m_123343_() + 0.5f), color);
                    this.sendToTrackers(packet);
                    if (wisp.isHostile) {
                        HOFEffectPacket packet2 = new HOFEffectPacket(HOFEffectPacket.HOFEffectType.CIRCLE, new Vector3f((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 1.0f, (float)pos.m_123343_() + 0.5f), 0xFF0000);
                        this.sendToTrackers(packet2);
                    }
                    this.playSound(wisp.isHostile ? SoundEvents.f_11880_ : SoundEvents.f_11862_, 1.0f, 1.0f);
                    break;
                }
            }
            this.m_6596_();
        }
        this.getRecipeContainer().setRecipe(null);
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.getRecipeContainer().read(compoundTag);
        this.displayDirty = true;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.getRecipeContainer().write(compound);
    }

    public void dropItems(Level worldIn, BlockPos pos) {
        if (worldIn != null && this.getRecipeContainer().hasRecipe() && this.getRecipeContainer().data != null) {
            this.getRecipeContainer().data.getItemData().forEach((i, v) -> {
                Item toDrop;
                if (v.booleanValue() && (toDrop = (Item)Registries.get((String)"whisperwoods").get(Registry.f_122904_).get(new ResourceLocation(i))) != null) {
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)toDrop));
                }
            });
        }
    }

    public static class CurrentRecipeContainer {
        private HOFRecipe currentRecipe = null;
        private RecipeItemData data = null;

        public void setRecipe(HOFRecipe recipe) {
            this.currentRecipe = recipe;
            this.data = recipe != null ? new RecipeItemData(recipe) : null;
        }

        public boolean hasRecipe() {
            return this.currentRecipe != null;
        }

        public boolean hasItemInRecipe(Item item) {
            return this.hasRecipe() && this.data != null && this.data.hasItem(item);
        }

        public boolean isRecipeComplete() {
            if (this.hasRecipe() && this.data != null) {
                boolean anyFalse = false;
                for (Item item : this.getCurrentRecipe().items) {
                    if (this.data.hasItem(item)) continue;
                    anyFalse = true;
                }
                return !anyFalse;
            }
            return false;
        }

        public HOFRecipe getCurrentRecipe() {
            return this.currentRecipe;
        }

        public boolean canRecipeAccept(Item item) {
            String next;
            if (this.hasRecipe() && this.data != null && (next = this.data.getNextNonContainedItem()) != null) {
                return next.equals(Registries.get((String)"whisperwoods").get(Registry.f_122904_).getId((Object)item).toString());
            }
            return false;
        }

        public boolean checkedAdd(Item item) {
            return this.canRecipeAccept(item) && this.data.addItem(item);
        }

        public Item getDisplayItem() {
            String itemName;
            if (this.hasRecipe() && this.data != null && (itemName = this.data.getNextNonContainedItem()) != null) {
                return (Item)Registries.get((String)"whisperwoods").get(Registry.f_122904_).get(new ResourceLocation(itemName));
            }
            return null;
        }

        public void read(CompoundTag nbt) {
            if (nbt.m_128441_("recipe") && !"empty".equals(nbt.m_128461_("recipe"))) {
                this.setRecipe((HOFRecipe)RECIPES.getOrDefault((Object)nbt.m_128461_("recipe"), null));
                if (this.data != null) {
                    this.data.read(nbt);
                }
            } else {
                this.setRecipe(null);
            }
        }

        public CompoundTag write(CompoundTag compound) {
            if (this.hasRecipe()) {
                compound.m_128359_("recipe", this.getCurrentRecipe().getName());
                if (this.data != null) {
                    this.data.write(compound);
                }
            } else {
                compound.m_128359_("recipe", "empty");
            }
            return compound;
        }
    }

    public static class HOFRecipe {
        private final ChatFormatting color;
        private final boolean bold;
        private String name = null;
        public final ImmutableList<Item> items;

        public HOFRecipe(ChatFormatting color, boolean bold, Item ... items) {
            if (items.length < 1) {
                throw new IllegalArgumentException("HOFRecipe constructor: \"items\" must have at least one item!");
            }
            this.color = color;
            this.bold = bold;
            this.items = ImmutableList.copyOf((Object[])items);
        }

        public ChatFormatting getColor() {
            return this.color;
        }

        public boolean isBold() {
            return this.bold;
        }

        public String getName() {
            if (this.name == null) {
                this.name = (String)RECIPES.inverse().get((Object)this);
            }
            return this.name;
        }

        public Item getFirst() {
            return (Item)this.items.get(0);
        }

        public Item getLast() {
            return (Item)this.items.get(this.items.size() - 1);
        }

        public boolean isFirst(Item item) {
            return item == this.getFirst();
        }

        public boolean isLast(Item item) {
            return item == this.getLast();
        }

        public boolean isMiddleIngredient(Item item) {
            return this.items.contains((Object)item) && !this.isFirst(item) && !this.isLast(item);
        }

        public Item getNextIngredient(Item lastIngredient) {
            int i = this.items.indexOf((Object)lastIngredient) + 1;
            if (!this.isLast(lastIngredient) && i < this.items.size()) {
                return (Item)this.items.get(i);
            }
            return null;
        }
    }

    public static class RecipeItemData {
        private final Map<String, Boolean> data = new LinkedHashMap<String, Boolean>();

        public RecipeItemData(HOFRecipe recipe) {
            recipe.items.forEach(item -> this.data.put(Registries.get((String)"whisperwoods").get(Registry.f_122904_).getId(item).toString(), false));
        }

        public RecipeItemData(HOFRecipe recipe, Set<String> items) {
            recipe.items.forEach(item -> {
                String key = Registries.get((String)"whisperwoods").get(Registry.f_122904_).getId(item).toString();
                this.data.put(key, items.contains(key));
            });
        }

        public String getNextNonContainedItem() {
            for (String key : this.data.keySet()) {
                if (this.data.get(key).booleanValue()) continue;
                return key;
            }
            return null;
        }

        public boolean addItem(Item item) {
            String key = Registries.get((String)"whisperwoods").get(Registry.f_122904_).getId((Object)item).toString();
            if (this.data.containsKey(key)) {
                this.data.put(key, true);
                return true;
            }
            return false;
        }

        public boolean hasItem(Item item) {
            return this.data.getOrDefault(Registries.get((String)"whisperwoods").get(Registry.f_122904_).getId((Object)item).toString(), false);
        }

        public void read(CompoundTag nbt) {
            if (nbt.m_128441_("items")) {
                nbt.m_128437_("items", 8).forEach(i -> this.data.put(i.m_7916_(), true));
            } else {
                this.data.keySet().forEach(i -> this.data.put((String)i, false));
            }
        }

        public CompoundTag write(CompoundTag compound) {
            ListTag list = new ListTag();
            this.data.forEach((i, v) -> {
                if (v.booleanValue()) {
                    list.add((Object)StringTag.m_129297_((String)i));
                }
            });
            compound.m_128365_("items", (Tag)list);
            return compound;
        }

        public Map<String, Boolean> getItemData() {
            return this.data;
        }
    }
}

