/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.itsmeow.whisperwoods.entity.EntityWisp;
import dev.itsmeow.whisperwoods.particle.WispParticleData;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class RenderWisp
extends LivingEntityRenderer<EntityWisp, EntityModel<EntityWisp>> {
    private final SkullModel head;

    public RenderWisp(EntityRendererProvider.Context ctx) {
        super(ctx, null, 0.0f);
        this.head = new SkullModel(ctx.m_174027_().m_171103_(ModelLayers.f_171163_));
    }

    public void render(EntityWisp entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        int color = entity.getWispColor().getColor();
        float r = color >> 16 & 0xFF;
        float g = color >> 8 & 0xFF;
        float b = color & 0xFF;
        float scale = 1.0f;
        if (entity.hasSoul()) {
            UUID target = UUID.fromString((String)entity.m_20088_().m_135370_(EntityWisp.TARGET_ID));
            String name = (String)entity.m_20088_().m_135370_(EntityWisp.TARGET_NAME);
            if (target != null && name != null && !name.equals("")) {
                stack.m_85836_();
                stack.m_85837_(0.0, (double)0.8f, 0.0);
                VertexConsumer vertex = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)entity.getTargetTexture()));
                this.head.m_142698_(0.0f, -entity.f_20885_, 180.0f + entity.m_146909_());
                this.head.m_7695_(stack, vertex, packedLightIn, OverlayTexture.f_118083_, r / 255.0f, g / 255.0f, b / 255.0f, 0.6f);
                stack.m_85837_(0.0, (double)0.4f, 0.0);
                this.m_7649_((Entity)entity, (Component)new TextComponent(name + "'s soul"), stack, bufferIn, packedLightIn);
                stack.m_85849_();
            }
        }
        if (!Minecraft.m_91087_().m_91104_() && System.nanoTime() - entity.lastSpawn >= 100000000L) {
            entity.lastSpawn = System.nanoTime();
            scale = (Integer)entity.m_20088_().m_135370_(EntityWisp.ATTACK_STATE) > 0 ? (400.0f - (float)((Integer)entity.m_20088_().m_135370_(EntityWisp.ATTACK_STATE)).intValue()) / 400.0f * 5.0f : ((Float)entity.m_20088_().m_135370_(EntityWisp.PASSIVE_SCALE)).floatValue();
            for (int i = 0; i < 2; ++i) {
                double xO = (double)(entity.m_21187_().nextFloat() * 2.0f - 1.0f) / 3.5;
                double yO = (entity.m_21187_().nextFloat() * 2.0f - 1.0f) / 6.0f + 0.8f;
                double zO = (double)(entity.m_21187_().nextFloat() * 2.0f - 1.0f) / 3.5;
                entity.f_19853_.m_7106_((ParticleOptions)new WispParticleData(r, g, b, scale), entity.m_20185_() + xO, entity.m_20186_() + yO, entity.m_20189_() + zO, 0.0, (double)0.005f, 0.0);
            }
            entity.f_19853_.m_7106_((ParticleOptions)new WispParticleData(r, g, b, scale), entity.m_20185_() + (double)((entity.m_21187_().nextFloat() * 2.0f - 1.0f) / 10.0f), entity.m_20186_() + (double)((entity.m_21187_().nextFloat() * 2.0f - 1.0f) / 5.0f) + (double)1.1f, entity.m_20189_() + (double)((entity.m_21187_().nextFloat() * 2.0f - 1.0f) / 10.0f), 0.0, (double)0.02f, 0.0);
        }
    }

    public ResourceLocation getTextureLocation(EntityWisp entity) {
        return null;
    }

    protected boolean shouldShowName(EntityWisp livingEntity) {
        return false;
    }
}

