/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.client.renderer.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.itsmeow.whisperwoods.blockentity.HGSkullBlockEntity;
import dev.itsmeow.whisperwoods.client.renderer.tile.model.ModelHGSkull;
import dev.itsmeow.whisperwoods.imdlib.block.AnimalSkullBlock;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public class RenderHGSkull
implements BlockEntityRenderer<HGSkullBlockEntity> {
    private final ModelHGSkull model;
    private static final ResourceLocation TEXTURE = new ResourceLocation("whisperwoods", "textures/entity/hirschgeist_bones.png");

    public RenderHGSkull(BlockEntityRendererProvider.Context ctx) {
        this.model = new ModelHGSkull(ctx.m_173582_(new ModelLayerLocation(new ResourceLocation("whisperwoods", "hirschgeist_skull"), "main")));
    }

    public void render(HGSkullBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState iblockstate = te.m_58900_();
        if (iblockstate == null || !(iblockstate.m_60734_() instanceof AnimalSkullBlock)) {
            return;
        }
        Direction enumfacing = te.getDirection();
        enumfacing = enumfacing == null ? Direction.NORTH : enumfacing;
        float rotation = -enumfacing.m_122435_();
        rotation = enumfacing == Direction.NORTH || enumfacing == Direction.SOUTH ? enumfacing.m_122424_().m_122435_() : rotation;
        rotation = enumfacing == Direction.UP ? te.getTopRotation() : rotation;
        this.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, enumfacing, rotation);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, int packedOverlayIn, Direction facing, float skullRotation) {
        matrixStackIn.m_85836_();
        RenderHGSkull.translateHead(matrixStackIn, facing, 1.32f);
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        float rotX = 0.0f;
        if (facing != null) {
            rotX = facing == Direction.UP ? 0.0f : 90.0f;
        }
        this.model.m_6973_(null, skullRotation, rotX, 0.0f, 0.0f, 0.0f);
        this.model.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE)), packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }

    private static void translateHead(PoseStack matrixStackIn, Direction face, float yOffset) {
        if (face == null) {
            matrixStackIn.m_85837_(0.5, (double)(0.25f + yOffset + 0.3f), 1.0);
            return;
        }
        switch (face) {
            case NORTH: {
                matrixStackIn.m_85837_(0.5, (double)(0.25f + yOffset + 0.3f), 1.0);
                break;
            }
            case EAST: {
                matrixStackIn.m_85837_(0.0, (double)(0.25f + yOffset + 0.3f), 0.5);
                break;
            }
            case SOUTH: {
                matrixStackIn.m_85837_(0.5, (double)(0.25f + yOffset + 0.3f), 0.0);
                break;
            }
            case WEST: {
                matrixStackIn.m_85837_(1.0, (double)(0.25f + yOffset + 0.3f), 0.5);
                break;
            }
            case UP: {
                matrixStackIn.m_85837_(0.5, (double)(0.18f + yOffset), 0.5);
                break;
            }
            default: {
                matrixStackIn.m_85837_(0.0, (double)(0.25f + yOffset + 0.3f), 0.5);
            }
        }
    }
}

