/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.util;

import dev.architectury.registry.registries.RegistrySupplier;
import dev.itsmeow.whisperwoods.block.GhostLightBlock;
import dev.itsmeow.whisperwoods.block.WispLanternBlock;
import dev.itsmeow.whisperwoods.init.ModBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WispColors {
    private static final List<WispColor> ARRAY = new ArrayList<WispColor>();
    private static final Map<Integer, WispColor> BY_COLOR = new HashMap<Integer, WispColor>();
    public static final WispColor BLUE = WispColors.r(new WispColor("BLUE", 61423, ModBlocks.GHOST_LIGHT_ELECTRIC_BLUE, ModBlocks.WISP_LANTERN_BLUE));
    public static final WispColor ORANGE = WispColors.r(new WispColor("ORANGE", 15894784, ModBlocks.GHOST_LIGHT_FIERY_ORANGE, ModBlocks.WISP_LANTERN_ORANGE));
    public static final WispColor YELLOW = WispColors.r(new WispColor("YELLOW", 16762396, ModBlocks.GHOST_LIGHT_GOLD, ModBlocks.WISP_LANTERN_YELLOW));
    public static final WispColor PURPLE = WispColors.r(new WispColor("PURPLE", 13248490, ModBlocks.GHOST_LIGHT_MAGIC_PURPLE, ModBlocks.WISP_LANTERN_PURPLE));
    public static final WispColor GREEN = WispColors.r(new WispColor("GREEN", 2883385, ModBlocks.GHOST_LIGHT_TOXIC_GREEN, ModBlocks.WISP_LANTERN_GREEN));

    private static WispColor r(WispColor c) {
        ARRAY.add(c);
        BY_COLOR.put(c.getColor(), c);
        return c;
    }

    public static WispColor byColor(int color) {
        return BY_COLOR.get(color);
    }

    public static WispColor[] values() {
        return ARRAY.toArray(new WispColor[0]);
    }

    public static final class WispColor {
        private final String name;
        private final int color;
        private final RegistrySupplier<GhostLightBlock> ghostLight;
        private final RegistrySupplier<WispLanternBlock> lantern;

        private WispColor(String name, int color, RegistrySupplier<GhostLightBlock> ghostLight, RegistrySupplier<WispLanternBlock> lantern) {
            this.name = name;
            this.color = color;
            this.ghostLight = ghostLight;
            this.lantern = lantern;
        }

        public RegistrySupplier<GhostLightBlock> getGhostLight() {
            return this.ghostLight;
        }

        public RegistrySupplier<WispLanternBlock> getLantern() {
            return this.lantern;
        }

        public String name() {
            return this.name;
        }

        public int ordinal() {
            return ARRAY.indexOf(this);
        }

        public int getColor() {
            return this.color;
        }

        public String toString() {
            return this.name + "/" + Integer.toHexString(this.color);
        }
    }
}

