/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.client.render;

import dev.itsmeow.whisperwoods.imdlib.client.render.BaseRenderer;
import dev.itsmeow.whisperwoods.imdlib.entity.interfaces.IVariantTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1296;
import net.minecraft.class_1308;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_630;
import org.apache.commons.lang3.tuple.Pair;

public class ImplRenderer<T extends class_1308, A extends class_583<T>>
extends BaseRenderer<T, A> {
    private final TextureContainer<T, A> textureContainer;
    private final ModelContainer<T, A> modelContainer;
    private final PreRenderCallback<T> preRenderCallback;
    private final HandleRotation<T> handleRotation;
    private final ApplyRotations<T> applyRotations;
    private final SuperCallApplyRotations applyRotationsSuper;
    private final RenderLayer<T> renderLayer;
    private final BlockLightLevel<T> blockLightLevel;

    public ImplRenderer(class_5617.class_5618 ctx, float shadow, TextureContainer<T, A> textureContainer, ModelContainer<T, A> modelContainer, PreRenderCallback<T> preRenderCallback, HandleRotation<T> handleRotation, ApplyRotations<T> applyRotations, SuperCallApplyRotations applyRotationsSuper, RenderLayer<T> renderLayer, BlockLightLevel<T> blockLightLevel) {
        super(ctx, modelContainer.getBaseModel(ctx), shadow);
        this.textureContainer = textureContainer;
        this.modelContainer = modelContainer;
        this.preRenderCallback = preRenderCallback;
        this.handleRotation = handleRotation;
        this.applyRotations = applyRotations;
        this.applyRotationsSuper = applyRotationsSuper;
        this.renderLayer = renderLayer;
        this.blockLightLevel = blockLightLevel;
    }

    public static <T extends class_1308, A extends class_583<T>> Builder<T, A> factory(String modid, float shadow) {
        return new Builder(modid, shadow);
    }

    private static class_2960 tex(String modid, String location) {
        return new class_2960(modid, "textures/entity/" + location + ".png");
    }

    private static class_5601 mll(String modid, String location) {
        return new class_5601(new class_2960(modid, location), "main");
    }

    protected void setupRotations(T e, class_4587 s, float a, float y, float p) {
        if (this.applyRotations == null) {
            super.method_4058(e, s, a, y, p);
        } else {
            if (this.applyRotationsSuper == SuperCallApplyRotations.PRE) {
                super.method_4058(e, s, a, y, p);
            }
            this.applyRotations.applyRotations(e, s, a, y, p);
            if (this.applyRotationsSuper == SuperCallApplyRotations.POST) {
                super.method_4058(e, s, a, y, p);
            }
        }
    }

    protected void scale(T e, class_4587 s, float p) {
        if (this.preRenderCallback != null) {
            this.preRenderCallback.preRenderCallback(e, s, p);
        }
    }

    protected float getBob(T e, float p) {
        return this.handleRotation == null ? super.method_4045(e, p) : this.handleRotation.handleRotation(e, p);
    }

    protected class_1921 getRenderType(T entity, boolean visible, boolean visibleToPlayer, boolean glowing) {
        return this.renderLayer == null ? super.method_24302(entity, visible, visibleToPlayer, glowing) : this.renderLayer.renderLayer(entity, visible, visibleToPlayer, glowing, this.getTextureLocation(entity));
    }

    protected int getBlockLightLevel(T entity, class_2338 blockPos) {
        return this.blockLightLevel == null ? super.method_24087(entity, blockPos) : this.blockLightLevel.blockLightLevel(entity, blockPos);
    }

    public void method_4072(T e, float p_225623_2_, float p_225623_3_, class_4587 p_225623_4_, class_4597 p_225623_5_, int p_225623_6_) {
        this.field_4737 = this.modelContainer.getModel(e);
        super.method_4072(e, p_225623_2_, p_225623_3_, p_225623_4_, p_225623_5_, p_225623_6_);
    }

    public class_2960 getTextureLocation(T entity) {
        return this.textureContainer.getTexture(entity);
    }

    public static class ModelContainer<T extends class_1308, A extends class_583<T>> {
        private final String modId;
        private final Strategy strategy;
        private final Function<class_5617.class_5618, A> baseModelProvider;
        private final Set<Pair<String, Function<class_5617.class_5618, class_583<T>>>> modelEntries = new HashSet<Pair<String, Function<class_5617.class_5618, class_583<T>>>>();
        private final Map<String, class_583<T>> builtModelMap = new HashMap<String, class_583<T>>();
        private Function<T, String> modelKeyMapper;
        private Function<class_5617.class_5618, class_583<T>> falseModelProvider;
        private Predicate<T> condition;
        private A baseModel;
        private A trueModel;
        private class_583<T> falseModel;

        public ModelContainer(String modid, Function<class_630, A> baseModel, String modelLayerLocation) {
            this.modId = modid;
            this.strategy = Strategy.SINGLE;
            this.baseModelProvider = ctx -> (class_583)baseModel.apply(ctx.method_32167(this.mll(modelLayerLocation)));
        }

        public ModelContainer(String modid, Function<T, String> modelMapper, Function<class_630, A> baseModel, String baseModelLocation) {
            this.modId = modid;
            this.strategy = Strategy.MAPPER;
            this.modelKeyMapper = modelMapper;
            this.baseModelProvider = this.convert(baseModel, baseModelLocation);
        }

        public ModelContainer(String modid, Predicate<T> condition, Function<class_630, A> trueModel, String trueLayerLocation, Function<class_630, class_583<T>> falseModel, String falseLayerLocation) {
            this.modId = modid;
            this.strategy = Strategy.CONDITION;
            this.condition = condition;
            this.baseModelProvider = this.convert(trueModel, trueLayerLocation);
            this.falseModelProvider = this.convert(falseModel, falseLayerLocation);
        }

        private <Z extends class_583<T>> Function<class_5617.class_5618, Z> convert(Function<class_630, Z> m, String location) {
            return ctx -> (class_583)m.apply(ctx.method_32167(this.mll(location)));
        }

        public void addMapperEntry(Function<class_630, class_583<T>> modelSupplier, String modelLayerLocation) {
            this.modelEntries.add(Pair.of((Object)modelLayerLocation, this.convert(modelSupplier, modelLayerLocation)));
        }

        public void provideContext(class_5617.class_5618 ctx) {
            this.baseModel = (class_583)this.baseModelProvider.apply(ctx);
            if (this.strategy == Strategy.MAPPER) {
                for (Pair<String, Function<class_5617.class_5618, class_583<T>>> pair : this.modelEntries) {
                    this.builtModelMap.put((String)pair.getLeft(), (class_583)((Function)pair.getRight()).apply(ctx));
                }
            } else if (this.strategy == Strategy.CONDITION) {
                this.trueModel = this.baseModel;
                this.falseModel = this.falseModelProvider.apply(ctx);
            }
        }

        public class_583<T> getModel(T entity) {
            if (this.baseModel == null) {
                throw new RuntimeException("getModel called before provideContext!");
            }
            switch (this.strategy) {
                case SINGLE: {
                    return this.baseModel;
                }
                case MAPPER: {
                    return this.getModelForKey(this.modelKeyMapper.apply(entity));
                }
                case CONDITION: {
                    return this.condition.test(entity) ? this.trueModel : this.falseModel;
                }
            }
            return this.baseModel;
        }

        public class_583<T> getModelForKey(String key) {
            return this.builtModelMap.getOrDefault(key, (class_583<T>)this.baseModel);
        }

        public A getBaseModel(class_5617.class_5618 ctx) {
            if (this.baseModel == null) {
                this.provideContext(ctx);
            }
            return this.baseModel;
        }

        private class_5601 mll(String loc) {
            return ImplRenderer.mll(this.modId, loc);
        }
    }

    public static class TextureContainer<T extends class_1308, A extends class_583<T>> {
        private final Strategy strategy;
        private class_2960 singleTexture;
        private Function<T, class_2960> texMapper;
        private class_2960 trueTex;
        private class_2960 falseTex;
        private Predicate<T> condition;
        private class_2960 conditionTex;

        public TextureContainer(class_2960 singleTexture) {
            this.strategy = Strategy.SINGLE;
            this.singleTexture = singleTexture;
        }

        public TextureContainer(Function<T, class_2960> texMapper) {
            this.strategy = Strategy.MAPPER;
            this.texMapper = texMapper;
        }

        public TextureContainer(Predicate<T> condition, Function<T, class_2960> texMapper, class_2960 conditionTex) {
            this.strategy = Strategy.MAPPER_CONDITION;
            this.texMapper = texMapper;
            this.condition = condition;
            this.conditionTex = conditionTex;
        }

        public TextureContainer(Predicate<T> condition, class_2960 trueTex, class_2960 falseTex) {
            this.strategy = Strategy.CONDITION;
            this.condition = condition;
            this.trueTex = trueTex;
            this.falseTex = falseTex;
        }

        public class_2960 getTexture(T entity) {
            switch (this.strategy) {
                case SINGLE: {
                    return this.singleTexture;
                }
                case MAPPER: {
                    return this.texMapper.apply(entity);
                }
                case CONDITION: {
                    return this.condition.test(entity) ? this.trueTex : this.falseTex;
                }
                case MAPPER_CONDITION: {
                    return this.condition.test(entity) ? this.conditionTex : this.texMapper.apply(entity);
                }
            }
            return null;
        }
    }

    @FunctionalInterface
    public static interface PreRenderCallback<T extends class_1308> {
        public void preRenderCallback(T var1, class_4587 var2, float var3);
    }

    @FunctionalInterface
    public static interface HandleRotation<T extends class_1308> {
        public float handleRotation(T var1, float var2);
    }

    @FunctionalInterface
    public static interface ApplyRotations<T extends class_1308> {
        public void applyRotations(T var1, class_4587 var2, float var3, float var4, float var5);
    }

    public static enum SuperCallApplyRotations {
        PRE,
        NONE,
        POST;

    }

    @FunctionalInterface
    public static interface RenderLayer<T extends class_1308> {
        public class_1921 renderLayer(T var1, boolean var2, boolean var3, boolean var4, class_2960 var5);
    }

    @FunctionalInterface
    public static interface BlockLightLevel<T extends class_1308> {
        public int blockLightLevel(T var1, class_2338 var2);
    }

    public static class Builder<T extends class_1308, A extends class_583<T>> {
        private final String modid;
        private final float shadow;
        private final ArrayList<Function<BaseRenderer<T, A>, class_3887<T, A>>> layers = new ArrayList();
        private final Map<String, class_2960> texMapper = new HashMap<String, class_2960>();
        private TextureContainer<T, A> tex;
        private ModelContainer<T, A> model;
        private PreRenderCallback<T> preRender;
        private HandleRotation<T> handleRotation;
        private ApplyRotations<T> applyRotations;
        private SuperCallApplyRotations superCallApplyRotations = SuperCallApplyRotations.NONE;
        private RenderLayer<T> renderLayer;
        private BlockLightLevel<T> blockLightLevel;

        protected Builder(String modid, float shadow) {
            this.modid = modid;
            this.shadow = shadow;
        }

        public Builder<T, A> layer(Function<BaseRenderer<T, A>, class_3887<T, A>> layer) {
            this.layers.add(layer);
            return this;
        }

        public Builder<T, A> tSingle(String texture) {
            this.tex = new TextureContainer(ImplRenderer.tex(this.modid, texture));
            return this;
        }

        public Builder<T, A> tCondition(Predicate<T> condition, String trueTex, String falseTex) {
            this.tex = new TextureContainer(condition, ImplRenderer.tex(this.modid, trueTex), ImplRenderer.tex(this.modid, falseTex));
            return this;
        }

        public Builder<T, A> tMapped(Function<T, String> texMapper) {
            this.tex = new TextureContainer(entity -> this.texStored((String)texMapper.apply(entity)));
            return this;
        }

        public Builder<T, A> tSingleRaw(class_2960 texture) {
            this.tex = new TextureContainer(texture);
            return this;
        }

        public Builder<T, A> tConditionRaw(Predicate<T> condition, class_2960 trueTex, class_2960 falseTex) {
            this.tex = new TextureContainer(condition, trueTex, falseTex);
            return this;
        }

        public Builder<T, A> tMappedRaw(Function<T, class_2960> texMapper) {
            this.tex = new TextureContainer(texMapper);
            return this;
        }

        public Builder<T, A> tVariant() {
            return this.tMappedRaw(e -> {
                if (e instanceof IVariantTypes) {
                    return ((IVariantTypes)e).getVariantTextureOrNull();
                }
                return null;
            });
        }

        public Builder<T, A> tMappedConditionRaw(Predicate<T> condition, Function<T, class_2960> texMapper, String conditionTex) {
            return this.tMappedConditionRaw(condition, texMapper, ImplRenderer.tex(this.modid, conditionTex));
        }

        public Builder<T, A> tMappedConditionRaw(Predicate<T> condition, Function<T, class_2960> texMapper, class_2960 conditionTex) {
            this.tex = new TextureContainer(condition, texMapper, conditionTex);
            return this;
        }

        public Builder<T, A> tVariantCondition(Predicate<T> condition, String conditionTex) {
            return this.tVariantCondition(condition, ImplRenderer.tex(this.modid, conditionTex));
        }

        public Builder<T, A> tVariantCondition(Predicate<T> condition, class_2960 conditionTex) {
            this.tex = new TextureContainer(condition, e -> {
                if (e instanceof IVariantTypes) {
                    return ((IVariantTypes)e).getVariantTextureOrNull();
                }
                return null;
            }, conditionTex);
            return this;
        }

        public Builder<T, A> tBabyVariant(String babyTex) {
            return this.tVariantCondition((T e) -> {
                if (e instanceof class_1296) {
                    return e.method_6109();
                }
                return false;
            }, ImplRenderer.tex(this.modid, babyTex));
        }

        public Builder<T, A> mSingle(Function<class_630, A> modelSupplier, String layerLocation) {
            this.model = new ModelContainer(this.modid, modelSupplier, layerLocation);
            return this;
        }

        public Builder<T, A> mMapped(Function<T, String> modelLocationMapper, Function<class_630, A> baseModelSupplier, String baseModelLayerLocation) {
            this.model = new ModelContainer<T, A>(this.modid, modelLocationMapper, baseModelSupplier, baseModelLayerLocation);
            return this;
        }

        public Builder<T, A> mEntry(Function<class_630, class_583<T>> modelSupplier, String modelLayerLocation) {
            if (this.model == null || this.model.strategy != Strategy.MAPPER) {
                throw new RuntimeException("Must call mMapped before mEntry!");
            }
            this.model.addMapperEntry(modelSupplier, modelLayerLocation);
            return this;
        }

        public Builder<T, A> mCondition(Predicate<T> condition, Function<class_630, A> trueModelSupplier, String trueLayerLocation, Function<class_630, class_583<T>> falseModelSupplier, String falseLayerLocation) {
            this.model = new ModelContainer<T, A>(this.modid, condition, trueModelSupplier, trueLayerLocation, falseModelSupplier, falseLayerLocation);
            return this;
        }

        public Builder<T, A> preRender(PreRenderCallback<T> preRender) {
            this.preRender = preRender;
            return this;
        }

        public Builder<T, A> simpleScale(Function<T, Float> function) {
            this.preRender((e, s, p) -> {
                float scale = ((Float)function.apply(e)).floatValue();
                s.method_22905(scale, scale, scale);
            });
            return this;
        }

        public Builder<T, A> condScale(Predicate<T> cond, float xScale, float yScale, float zScale) {
            this.preRender((e, s, p) -> {
                if (cond.test(e)) {
                    s.method_22905(xScale, yScale, zScale);
                }
            });
            return this;
        }

        public Builder<T, A> condScale(Predicate<T> cond, float scale) {
            return this.condScale(cond, scale, scale, scale);
        }

        public Builder<T, A> condDualScale(Predicate<T> cond, float truexScale, float trueyScale, float truezScale, float falsexScale, float falseyScale, float falsezScale) {
            this.preRender((e, s, p) -> {
                if (cond.test(e)) {
                    s.method_22905(truexScale, trueyScale, truezScale);
                } else {
                    s.method_22905(falsexScale, falseyScale, falsezScale);
                }
            });
            return this;
        }

        public Builder<T, A> condDualScale(Predicate<T> cond, float trueScale, float falseScale) {
            return this.condDualScale(cond, trueScale, trueScale, trueScale, falseScale, falseScale, falseScale);
        }

        public Builder<T, A> childScale(float xScale, float yScale, float zScale) {
            this.preRender((e, s, p) -> {
                if (e instanceof class_1296 && e.method_6109()) {
                    s.method_22905(xScale, yScale, zScale);
                }
            });
            return this;
        }

        public Builder<T, A> childScale(float scale) {
            return this.childScale(scale, scale, scale);
        }

        public Builder<T, A> ageScale(float adultxScale, float adultyScale, float adultzScale, float childxScale, float childyScale, float childzScale) {
            this.preRender((e, s, p) -> {
                if (e instanceof class_1296) {
                    if (e.method_6109()) {
                        s.method_22905(childxScale, childyScale, childzScale);
                    } else {
                        s.method_22905(adultxScale, adultyScale, adultzScale);
                    }
                }
            });
            return this;
        }

        public Builder<T, A> ageScale(float adultScale, float childScale) {
            return this.ageScale(adultScale, adultScale, adultScale, childScale, childScale, childScale);
        }

        public Builder<T, A> handleRotation(HandleRotation<T> handleRotationFunc) {
            this.handleRotation = handleRotationFunc;
            return this;
        }

        public Builder<T, A> applyRotations(ApplyRotations<T> applyRotationsFunc, SuperCallApplyRotations superCall) {
            this.superCallApplyRotations = superCall;
            return this.applyRotations(applyRotationsFunc);
        }

        public Builder<T, A> applyRotations(ApplyRotations<T> applyRotationsFunc) {
            this.applyRotations = applyRotationsFunc;
            return this;
        }

        public Builder<T, A> renderLayer(RenderLayer<T> renderLayerFunc) {
            this.renderLayer = renderLayerFunc;
            return this;
        }

        public Builder<T, A> blockLightLevel(BlockLightLevel<T> blockLightLevel) {
            this.blockLightLevel = blockLightLevel;
            return this;
        }

        public class_5617 done() {
            if (this.tex == null || this.model == null) {
                throw new IllegalArgumentException("Must define both a texture and a model before calling build()!");
            }
            return ctx -> new ImplRenderer<T, A>(ctx, this.shadow, this.tex, this.model, this.preRender, this.handleRotation, this.applyRotations, this.superCallApplyRotations, this.renderLayer, this.blockLightLevel).layers(this.layers);
        }

        private class_2960 texStored(String location) {
            return this.texMapper.computeIfAbsent(location, l -> ImplRenderer.tex(this.modid, l));
        }
    }

    @FunctionalInterface
    public static interface RenderDef<T extends class_1308, A extends class_583<T>> {
        public Builder<T, A> apply(Builder<T, A> var1);
    }

    public static enum Strategy {
        SINGLE,
        MAPPER,
        MAPPER_CONDITION,
        CONDITION;

    }
}

