/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.itsmeow.whisperwoods.init.ModParticles;
import java.util.Locale;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WispParticleData
implements ParticleOptions {
    public static final Codec<WispParticleData> CODEC = RecordCodecBuilder.create(group -> group.group((App)Codec.FLOAT.fieldOf("r").forGetter(in -> Float.valueOf(in.getRed())), (App)Codec.FLOAT.fieldOf("g").forGetter(in -> Float.valueOf(in.getGreen())), (App)Codec.FLOAT.fieldOf("b").forGetter(in -> Float.valueOf(in.getBlue())), (App)Codec.FLOAT.fieldOf("scale").forGetter(in -> Float.valueOf(in.getScale()))).apply((Applicative)group, WispParticleData::new));
    public static final ParticleOptions.Deserializer<WispParticleData> DESERIALIZER = new ParticleOptions.Deserializer<WispParticleData>(){

        public WispParticleData fromCommand(ParticleType<WispParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float f = (float)reader.readDouble();
            reader.expect(' ');
            float f1 = (float)reader.readDouble();
            reader.expect(' ');
            float f2 = (float)reader.readDouble();
            reader.expect(' ');
            float f3 = (float)reader.readDouble();
            return new WispParticleData(f, f1, f2, f3);
        }

        public WispParticleData fromNetwork(ParticleType<WispParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new WispParticleData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    private final float red;
    private final float green;
    private final float blue;
    private final float scale;

    public WispParticleData(float r, float g, float b, float scale) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.scale = scale;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
        buffer.writeFloat(this.scale);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", Registry.f_122829_.m_7981_(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.scale));
    }

    public ParticleType<WispParticleData> m_6012_() {
        return (ParticleType)ModParticles.WISP.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRed() {
        return this.red;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getGreen() {
        return this.green;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getBlue() {
        return this.blue;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getScale() {
        return this.scale;
    }
}

