/*
 * Decompiled with CFR 0.152.
 */
package its_meow.whisperwoods.config;

import its_meow.whisperwoods.WhisperwoodsMod;
import its_meow.whisperwoods.init.ModEntities;
import its_meow.whisperwoods.util.EntityTypeContainer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="whisperwoods", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WhisperwoodsConfig {
    private static EntityConfig ENTITY_CONFIG = null;
    public static ForgeConfigSpec SERVER_CONFIG = null;

    public static void setupConfig() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(EntityConfig::new);
        SERVER_CONFIG = (ForgeConfigSpec)specPair.getRight();
        ENTITY_CONFIG = (EntityConfig)specPair.getLeft();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        WhisperwoodsMod.LOGGER.debug("Loading {} {}", (Object)"whisperwoods", (Object)configEvent.getConfig().getFileName());
        if (configEvent.getConfig().getSpec() == SERVER_CONFIG) {
            ENTITY_CONFIG.onWorldLoad();
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.ConfigReloading configEvent) {
        WhisperwoodsMod.LOGGER.debug("Reloading {} {}", (Object)"whisperwoods", (Object)configEvent.getConfig().getFileName());
        if (configEvent.getConfig().getSpec() == SERVER_CONFIG) {
            ENTITY_CONFIG.loadEntityData();
        }
    }

    public static class EntityConfig {
        public ForgeConfigSpec.Builder builder;

        EntityConfig(ForgeConfigSpec.Builder builder) {
            this.builder = builder;
            for (EntityTypeContainer<? extends LivingEntity> cont : ModEntities.ENTITIES.values()) {
                cont.initConfiguration(builder);
            }
            builder.build();
        }

        public void loadEntityData() {
            for (EntityTypeContainer<? extends LivingEntity> container : ModEntities.ENTITIES.values()) {
                EntityTypeContainer.EntityConfiguration section = container.getConfiguration();
                container.spawnMaxGroup = (Integer)section.spawnMaxGroup.get();
                container.spawnMinGroup = (Integer)section.spawnMinGroup.get();
                container.spawnWeight = (Integer)section.spawnWeight.get();
                container.doSpawning = (Boolean)section.doSpawning.get();
                container.despawn = (Boolean)section.doDespawn.get();
                container.customConfigurationLoad();
                ArrayList<Biome> biomesList = new ArrayList<Biome>();
                for (String biomeID : (List)section.biomesList.get()) {
                    Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeID));
                    if (biome == null) {
                        WhisperwoodsMod.LOGGER.error("Invalid biome configuration entered for entity \"" + container.entityName + "\" (biome was mistyped or a biome mod was removed?): " + biomeID);
                        continue;
                    }
                    biomesList.add(biome);
                }
                container.setBiomes(biomesList.toArray(new Biome[0]));
            }
        }

        public void onWorldLoad() {
            this.loadEntityData();
            if (!ModEntities.ENTITIES.values().isEmpty()) {
                for (EntityTypeContainer<? extends LivingEntity> entry : ModEntities.ENTITIES.values()) {
                    EntityType type = entry.entityType;
                    if (!entry.doSpawning) continue;
                    if (entry.spawnType == EntityClassification.WATER_CREATURE && EntitySpawnPlacementRegistry.func_209344_a(type) == null) {
                        try {
                            EntitySpawnPlacementRegistry.func_209343_a(type, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (t, w, s, b, r) -> b.func_177956_o() > 45 && b.func_177956_o() < w.func_181545_F());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Method addSpawn = ObfuscationReflectionHelper.findMethod(Biome.class, (String)"func_201866_a", (Class[])new Class[]{EntityClassification.class, Biome.SpawnListEntry.class});
                    for (Biome biome : entry.getBiomes()) {
                        try {
                            addSpawn.invoke((Object)biome, entry.spawnType, new Biome.SpawnListEntry(type, entry.spawnWeight, entry.spawnMinGroup, entry.spawnMaxGroup));
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

