/*
 * Decompiled with CFR 0.152.
 */
package its_meow.whisperwoods.entity;

import its_meow.whisperwoods.entity.EntityAnimalWithTypes;
import javax.annotation.Nullable;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class EntityAnimalWithTypesAndSize
extends EntityAnimalWithTypes {
    protected static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityAnimalWithTypesAndSize.class, (IDataSerializer)DataSerializers.field_187193_c);

    public EntityAnimalWithTypesAndSize(EntityType<? extends EntityAnimalWithTypes> entityType, World worldIn) {
        super(entityType, worldIn);
        this.setSize(0.35f, 0.35f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
    }

    public EntitySize func_213305_a(Pose pose) {
        float size = ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
        return EntitySize.func_220314_b((float)size, (float)size).func_220313_a(this.func_213355_cm());
    }

    public void setSize(float width, float height) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(width));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("Size", this.func_213305_a((Pose)Pose.STANDING).field_220315_a);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        float size = compound.func_74760_g("Size");
        this.setSize(size, size);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, CompoundNBT compound) {
        livingdata = super.func_213386_a(world, difficulty, reason, livingdata, compound);
        if (!this.func_70631_g_()) {
            int i = this.getRandomType();
            float rand = this.getRandomizedSize();
            if (livingdata instanceof SizeTypeData) {
                i = ((SizeTypeData)livingdata).typeData;
                rand = ((SizeTypeData)livingdata).size;
            } else {
                livingdata = new SizeTypeData(i, rand);
            }
            this.setType(i);
            this.setSize(rand, rand);
        }
        this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
        return livingdata;
    }

    protected abstract float getRandomizedSize();

    public static class SizeTypeData
    implements ILivingEntityData {
        public int typeData;
        public float size;

        public SizeTypeData(int type, float size) {
            this.typeData = type;
            this.size = size;
        }
    }
}

