/*
 * Decompiled with CFR 0.152.
 */
package its_meow.whisperwoods.entity;

import its_meow.whisperwoods.block.BlockGhostLight;
import its_meow.whisperwoods.init.ModBlocks;
import its_meow.whisperwoods.init.ModEntities;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityWisp
extends AnimalEntity {
    public final DamageSource WISP = new EntityDamageSource("wisp", (Entity)this).func_151518_m().func_76348_h();
    public static int HOSTILE_CHANCE = 8;
    public boolean isHostile = false;
    public long lastSpawn = 0L;
    private BlockPos targetPosition;
    public static final DataParameter<Integer> ATTACK_STATE = EntityDataManager.func_187226_a(EntityWisp.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<String> TARGET = EntityDataManager.func_187226_a(EntityWisp.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> TARGET_NAME = EntityDataManager.func_187226_a(EntityWisp.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Float> PASSIVE_SCALE = EntityDataManager.func_187226_a(EntityWisp.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Integer> COLOR_VARIANT = EntityDataManager.func_187226_a(EntityWisp.class, (IDataSerializer)DataSerializers.field_187192_b);

    protected EntityWisp(EntityType<? extends EntityWisp> entityType, World world) {
        super(entityType, world);
    }

    public EntityWisp(World world) {
        this(ModEntities.WISP.entityType, world);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.5);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_STATE, (Object)0);
        this.field_70180_af.func_187214_a(TARGET, (Object)"");
        this.field_70180_af.func_187214_a(TARGET_NAME, (Object)"");
        this.field_70180_af.func_187214_a(PASSIVE_SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_VARIANT, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int state = (Integer)this.field_70180_af.func_187225_a(ATTACK_STATE);
        if (state == 0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 0.6, 0.5));
            this.field_70145_X = false;
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
            this.field_70145_X = true;
            this.field_70180_af.func_187227_b(ATTACK_STATE, (Object)(state + 1));
        }
        if (state == 400 && !this.field_70170_p.field_72995_K) {
            PlayerEntity soul = null;
            if (this.func_70638_az() instanceof PlayerEntity) {
                soul = (PlayerEntity)this.func_70638_az();
            }
            if (soul == null) {
                soul = this.field_70170_p.func_73046_m().func_184103_al().func_177451_a(UUID.fromString((String)this.field_70180_af.func_187225_a(TARGET)));
            }
            if (soul == null) {
                soul = this.field_70170_p.func_73046_m().func_184103_al().func_152612_a((String)this.field_70180_af.func_187225_a(TARGET_NAME));
            }
            this.field_70180_af.func_187227_b(ATTACK_STATE, (Object)0);
            this.field_70180_af.func_187227_b(TARGET, (Object)"");
            this.field_70180_af.func_187227_b(TARGET_NAME, (Object)"");
            soul.func_70097_a(this.WISP, 3000.0f);
            this.targetPosition = null;
            this.func_70624_b(null);
        }
        if (!this.isHostile && !this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(10.0)).size() > 0) {
                PlayerEntity nearest = (PlayerEntity)this.field_70170_p.func_217360_a(PlayerEntity.class, new EntityPredicate().func_221008_a().func_221011_b().func_221009_d(), null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_174813_aQ().func_186662_g(10.0));
                if (nearest != null) {
                    this.field_70180_af.func_187227_b(PASSIVE_SCALE, (Object)Float.valueOf(nearest.func_70032_d((Entity)this) / 12.0f));
                } else {
                    this.field_70180_af.func_187227_b(PASSIVE_SCALE, (Object)Float.valueOf(0.3f));
                }
            } else {
                this.field_70180_af.func_187227_b(PASSIVE_SCALE, (Object)Float.valueOf(1.0f));
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        int state = (Integer)this.field_70180_af.func_187225_a(ATTACK_STATE);
        if (this.func_70638_az() != null && this.func_70638_az().func_190530_aW()) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() == null && this.isHostile) {
            this.field_70180_af.func_187227_b(ATTACK_STATE, (Object)0);
            this.field_70180_af.func_187227_b(TARGET, (Object)"");
            this.field_70180_af.func_187227_b(TARGET_NAME, (Object)"");
        }
        if (this.targetPosition != null && this.func_180425_c().func_177951_i((Vec3i)this.targetPosition) < 4.0 || this.targetPosition == null || !this.isHostile || this.isHostile && state == 0) {
            if (this.func_70638_az() == null && this.isHostile) {
                this.func_70624_b(this.field_70170_p.func_217360_a(PlayerEntity.class, EntityPredicate.field_221016_a, null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_174813_aQ().func_186662_g(25.0)));
            }
            this.targetPosition = this.isHostile && this.func_70638_az() != null ? this.func_70638_az().func_180425_c() : new BlockPos(this.field_70165_t + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5), this.field_70163_u + (double)this.field_70146_Z.nextInt(4) - 0.1, this.field_70161_v + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5));
            if (state > 0 && this.isHostile) {
                this.targetPosition = new BlockPos(this.field_70165_t + (double)this.field_70146_Z.nextInt(60) - (double)this.field_70146_Z.nextInt(60), this.field_70163_u + (double)this.field_70146_Z.nextInt(4), this.field_70161_v + (double)this.field_70146_Z.nextInt(60) - (double)this.field_70146_Z.nextInt(60));
            }
        }
        if (this.targetPosition != null) {
            double d0 = (double)this.targetPosition.func_177958_n() + 0.5 - this.field_70165_t;
            double d1 = (double)this.targetPosition.func_177956_o() + 0.1 - this.field_70163_u;
            double d2 = (double)this.targetPosition.func_177952_p() + 0.5 - this.field_70161_v;
            Vec3d vec3d = this.func_213322_ci();
            Vec3d vec3d1 = vec3d.func_72441_c((Math.signum(d0) * 0.5 - vec3d.field_72450_a) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.field_72448_b) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.field_72449_c) * (double)0.1f);
            this.func_213317_d(vec3d1);
            float f = (float)(MathHelper.func_181159_b((double)vec3d1.field_72449_c, (double)vec3d1.field_72450_a) * 57.2957763671875) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += f1;
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    protected void func_82167_n(Entity entity) {
        if (entity == this.func_70638_az() && this.func_70638_az() != null && entity instanceof PlayerEntity && (Integer)this.field_70180_af.func_187225_a(ATTACK_STATE) == 0) {
            PlayerEntity player = (PlayerEntity)entity;
            this.field_70180_af.func_187227_b(ATTACK_STATE, (Object)1);
            this.field_70180_af.func_187227_b(TARGET, (Object)player.func_146103_bH().getId().toString());
            this.field_70180_af.func_187227_b(TARGET_NAME, (Object)player.func_146103_bH().getName());
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public boolean func_213397_c(double range) {
        return ModEntities.ENTITIES.containsKey("wisp") ? ModEntities.ENTITIES.get((Object)"wisp").despawn && (Integer)this.field_70180_af.func_187225_a(ATTACK_STATE) == 0 : false;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("is_hostile", this.isHostile);
        compound.func_74768_a("color_variant", ((Integer)this.field_70180_af.func_187225_a(COLOR_VARIANT)).intValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.isHostile = compound.func_74767_n("is_hostile");
        this.field_70180_af.func_187227_b(COLOR_VARIANT, (Object)compound.func_74762_e("color_variant"));
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        int variant = (Integer)this.func_184212_Q().func_187225_a(COLOR_VARIANT);
        if (!(this.field_70170_p.field_72995_K || this.func_70631_g_() || this.field_70146_Z.nextInt(20) >= 2 && (Integer)this.field_70180_af.func_187225_a(ATTACK_STATE) <= 0)) {
            ItemStack stack = new ItemStack((IItemProvider)EntityWisp.getItemForVariant(variant));
            this.func_70099_a(stack, 0.5f);
        }
    }

    private static Item getItemForVariant(int variant) {
        BlockGhostLight block = null;
        switch (variant) {
            case 1: {
                block = ModBlocks.GHOST_LIGHT_ELECTRIC_BLUE;
                break;
            }
            case 2: {
                block = ModBlocks.GHOST_LIGHT_FIERY_ORANGE;
                break;
            }
            case 3: {
                block = ModBlocks.GHOST_LIGHT_GOLD;
                break;
            }
            case 4: {
                block = ModBlocks.GHOST_LIGHT_TOXIC_GREEN;
                break;
            }
            case 5: {
                block = ModBlocks.GHOST_LIGHT_MAGIC_PURPLE;
            }
        }
        if (block == null) {
            return null;
        }
        return block.func_199767_j();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, CompoundNBT compound) {
        if (!this.func_70631_g_()) {
            boolean hostile = this.func_70681_au().nextInt(HOSTILE_CHANCE) == 0;
            int colorVariant = this.func_70681_au().nextInt(5) + 1;
            if (livingdata instanceof WispData) {
                hostile = ((WispData)livingdata).isHostile;
                colorVariant = ((WispData)livingdata).colorVariant;
            } else {
                livingdata = new WispData(hostile, colorVariant);
            }
            this.isHostile = hostile;
            this.field_70180_af.func_187227_b(COLOR_VARIANT, (Object)colorVariant);
        }
        return livingdata;
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    public static class WispData
    implements ILivingEntityData {
        public boolean isHostile;
        public int colorVariant;

        public WispData(boolean isHostile, int colorVariant) {
            this.isHostile = isHostile;
            this.colorVariant = colorVariant;
        }
    }
}

