/*
 * Decompiled with CFR 0.152.
 */
package its_meow.whisperwoods.init;

import its_meow.whisperwoods.WhisperwoodsMod;
import its_meow.whisperwoods.entity.EntityHidebehind;
import its_meow.whisperwoods.entity.EntityMoth;
import its_meow.whisperwoods.entity.EntityWisp;
import its_meow.whisperwoods.util.EntityTypeContainer;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ModEntities {
    public static final LinkedHashMap<String, EntityTypeContainer<? extends LivingEntity>> ENTITIES = new LinkedHashMap();
    public static final EntityTypeContainer<EntityMoth> MOTH = ModEntities.setupContainer(new EntityTypeContainer<EntityMoth>(EntityMoth.class, EntityMoth::new, "moth", EntityClassification.AMBIENT, 4465942, 13000993, 10, 1, 3, 0.35f, 0.35f, true, new EntityTypeContainer.CustomConfigurationHolder(){
        private ForgeConfigSpec.IntValue requiredMoths;

        @Override
        protected void customConfigurationInit(ForgeConfigSpec.Builder builder) {
            this.requiredMoths = builder.comment("How many moths required to destroy a torch - Disabled if set to 0").worldRestart().defineInRange("moths_to_destroy_torch", 5, 0, Integer.MAX_VALUE);
        }

        @Override
        protected void customConfigurationLoad() {
            EntityMoth.MOTHS_REQUIRED_TO_DESTROY = (Integer)this.requiredMoths.get();
        }
    }, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP));
    public static final EntityTypeContainer<EntityHidebehind> HIDEBEHIND = ModEntities.setupContainer(new EntityTypeContainer<EntityHidebehind>(EntityHidebehind.class, EntityHidebehind::new, "hidebehind", EntityClassification.MONSTER, 4665635, 0xFFF494, 7, 1, 1, 1.0f, 5.2f, true, null, BiomeDictionary.Type.FOREST));
    public static final EntityTypeContainer<EntityWisp> WISP = ModEntities.setupContainer(new EntityTypeContainer<EntityWisp>(EntityWisp.class, EntityWisp::new, "wisp", EntityClassification.CREATURE, 12805126, 16760840, 10, 1, 3, 0.75f, 0.9f, true, new EntityTypeContainer.CustomConfigurationHolder(){
        private ForgeConfigSpec.IntValue hostileChance;

        @Override
        protected void customConfigurationInit(ForgeConfigSpec.Builder builder) {
            this.hostileChance = builder.comment("Chance of wisp being hostile (soul stealer). Chance is 1/x, where x is the value specified. 0 is no chance, 1 is 100% chance, 2 is 50% chance, etc").worldRestart().defineInRange("hostile_chance", 8, 0, Integer.MAX_VALUE);
        }

        @Override
        protected void customConfigurationLoad() {
            EntityWisp.HOSTILE_CHANCE = (Integer)this.hostileChance.get();
        }
    }, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP));
    private static Field type$serializable = null;

    public static <T extends LivingEntity> EntityTypeContainer<T> getEntityTypeContainer(String name) {
        return ENTITIES.get(name);
    }

    public static <T extends LivingEntity> EntityType<T> getEntityType(String name) {
        return ModEntities.ENTITIES.get((Object)name).entityType;
    }

    private static <T extends LivingEntity> EntityTypeContainer<T> setupContainer(EntityTypeContainer<T> c) {
        c.entityType = ModEntities.createEntityType(c);
        ENTITIES.put(c.entityName, c);
        return c;
    }

    public static <T extends LivingEntity> EntityType<T> createEntityType(EntityTypeContainer<T> container) {
        return ModEntities.createEntityType(container.entityClass, container.factory, container.entityName, container.spawnType, 64, 1, true, container.width, container.height);
    }

    public static <T extends Entity> EntityType<T> createEntityType(Class<T> EntityClass, Function<World, T> func, String entityNameIn, EntityClassification classification, int trackingRange, int updateInterval, boolean velUpdates, float width, float height) {
        EntityType type = EntityType.Builder.func_220322_a((etype, world) -> (Entity)func.apply(world), (EntityClassification)classification).setTrackingRange(trackingRange).setUpdateInterval(updateInterval).setShouldReceiveVelocityUpdates(velUpdates).func_220321_a(width, height).setCustomClientFactory((e, world) -> (Entity)func.apply((World)world)).func_200706_c().func_206830_a("whisperwoods:" + entityNameIn.toLowerCase());
        type.setRegistryName("whisperwoods:" + entityNameIn.toLowerCase());
        try {
            if (type$serializable == null) {
                type$serializable = ObfuscationReflectionHelper.findField(EntityType.class, (String)"field_200733_aL");
            }
            ModEntities.setFinalField(type$serializable, type, true);
        }
        catch (Exception e2) {
            WhisperwoodsMod.LOGGER.warn("Unable to set serializable for " + entityNameIn + ". This could result in possible saving issues with entities!");
        }
        return type;
    }

    private static void setFinalField(Field field, Object object, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(object, newValue);
    }
}

