/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.block;

import dev.itsmeow.whisperwoods.block.BlockGhostLight;
import dev.itsmeow.whisperwoods.tileentity.TileEntityHandOfFate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockHandOfFate
extends Block {
    public static final EnumProperty<Orientation> ROTATION = EnumProperty.func_177709_a((String)"rotation", Orientation.class);
    private static VoxelShape SHAPE;

    public BlockHandOfFate(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(ROTATION, (Comparable)((Object)Orientation.NORTH))).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean isLit(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this && world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockGhostLight;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof TileEntityHandOfFate) {
                ((TileEntityHandOfFate)te).dropItems(worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity te;
        ItemStack held = player.func_184586_b(hand);
        boolean lit = this.isLit(worldIn, pos);
        if (held.func_77973_b() instanceof BlockItem && ((BlockItem)held.func_77973_b()).func_179223_d() instanceof BlockGhostLight && !lit) {
            BlockItem i = (BlockItem)held.func_77973_b();
            if (worldIn.func_175623_d(pos.func_177984_a())) {
                if (!player.func_184812_l_()) {
                    held.func_190918_g(1);
                }
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldIn.func_175656_a(pos.func_177984_a(), i.func_179223_d().func_176223_P());
                return ActionResultType.CONSUME;
            }
            return ActionResultType.FAIL;
        }
        if (worldIn.func_175625_s(pos) != null && (te = worldIn.func_175625_s(pos)) instanceof TileEntityHandOfFate) {
            TileEntityHandOfFate tehof = (TileEntityHandOfFate)te;
            return tehof.onBlockActivated(state, worldIn, pos, player, hand, hit);
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ROTATION, BlockStateProperties.field_208198_y});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP) && (!worldIn.func_180495_p(pos.func_177984_a()).func_200132_m() || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockGhostLight);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(ROTATION, (Comparable)((Object)Orientation.fromAngle((360.0f + context.func_195990_h() % 360.0f) % 360.0f)))).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader worldIn) {
        return new TileEntityHandOfFate();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        Style gIS = new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true));
        String tooltipPrefix = "block.whisperwoods.hand_of_fate.tooltip.";
        String recipePrefix = tooltipPrefix + "recipe.";
        if (Screen.hasShiftDown()) {
            tooltip.add(new TranslationTextComponent(tooltipPrefix + "recipehint", new Object[0]).func_150255_a(gIS));
            for (String recipeKey : TileEntityHandOfFate.RECIPES.keySet()) {
                TileEntityHandOfFate.HOFRecipe recipe = (TileEntityHandOfFate.HOFRecipe)TileEntityHandOfFate.RECIPES.get((Object)recipeKey);
                ITextComponent t = new TranslationTextComponent(recipePrefix + recipeKey, new Object[0]).func_150255_a(new Style().func_150238_a(recipe.getColor()).func_150227_a(Boolean.valueOf(recipe.isBold()))).func_150258_a(": ").func_150257_a(new TranslationTextComponent(recipe.getFirst().func_77658_a(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false))));
                if (I18n.func_188566_a((String)(recipePrefix + recipeKey + ".hint"))) {
                    t.func_150258_a(" ").func_150257_a(new TranslationTextComponent(recipePrefix + recipeKey + ".hint", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150227_a(Boolean.valueOf(false))));
                }
                tooltip.add(t);
            }
        } else {
            tooltip.add(new TranslationTextComponent(tooltipPrefix + "shiftdown", new Object[0]).func_150255_a(gIS));
        }
    }

    static {
        double d = 0.1875;
        SHAPE = VoxelShapes.func_197873_a((double)d, (double)0.0, (double)d, (double)(1.0 - d), (double)1.55, (double)(1.0 - d));
    }

    public static enum Orientation implements IStringSerializable
    {
        SOUTH(Direction.SOUTH),
        SOUTHWEST(Direction.SOUTH, Direction.WEST),
        WEST(Direction.WEST),
        NORTHWEST(Direction.NORTH, Direction.WEST),
        NORTH(Direction.NORTH),
        NORTHEAST(Direction.NORTH, Direction.EAST),
        EAST(Direction.EAST),
        SOUTHEAST(Direction.SOUTH, Direction.EAST);

        Direction[] directions;

        private Orientation(Direction ... directions) {
            this.directions = directions;
        }

        public static Orientation nearestYaw(float yaw) {
            return null;
        }

        public static Orientation fromAngle(double angle) {
            return Orientation.byIndex(MathHelper.func_76128_c((double)(angle / 45.0 + 0.5)));
        }

        public static Orientation byIndex(int index) {
            return Orientation.values()[MathHelper.func_76130_a((int)(index % 8))];
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public float getHorizontalAngle() {
            return (float)this.ordinal() * 45.0f;
        }
    }
}

