/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.block;

import dev.itsmeow.whisperwoods.tileentity.TileEntityGhostLight;
import dev.itsmeow.whisperwoods.util.IHaveColor;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class BlockWispLantern
extends Block
implements IWaterLoggable,
IHaveColor {
    private static VoxelShape[] SHAPES = new VoxelShape[Direction.values().length];
    public static final BooleanProperty WATERLOGGED;
    public static final DirectionProperty FACING;
    public static final DirectionProperty HORIZONTAL_FACING;
    private int color = 0;

    public BlockWispLantern(int color, Block.Properties properties) {
        super(properties);
        this.color = color;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.DOWN)).func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader worldIn) {
        return new TileEntityGhostLight();
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext ctx) {
        return SHAPES[((Direction)state.func_177229_b((IProperty)FACING)).ordinal()];
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate = (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)direction);
            if (!blockstate.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            if (direction.func_176740_k() == Direction.Axis.Y) {
                blockstate = (BlockState)blockstate.func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)context.func_195999_j().func_184172_bi().func_176734_d());
            }
            return (BlockState)blockstate.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, HORIZONTAL_FACING, WATERLOGGED});
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(direction), (Direction)direction.func_176734_d());
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return stateIn.func_177229_b((IProperty)FACING) == facing && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    static {
        for (Direction facing : Direction.values()) {
            int x;
            double d = 0.25;
            if (facing == Direction.UP) {
                BlockWispLantern.SHAPES[facing.ordinal()] = VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
                continue;
            }
            if (facing == Direction.DOWN) {
                BlockWispLantern.SHAPES[facing.ordinal()] = VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.8125, (double)0.75);
                continue;
            }
            int n = facing == Direction.WEST ? 1 : (x = facing == Direction.EAST ? -1 : 0);
            int z = facing == Direction.NORTH ? 1 : (facing == Direction.SOUTH ? -1 : 0);
            BlockWispLantern.SHAPES[facing.ordinal()] = VoxelShapes.func_197873_a((double)(0.25 - 0.25 * (double)x), (double)0.0, (double)(0.25 - 0.25 * (double)z), (double)(0.75 - 0.25 * (double)x), (double)0.8125, (double)(0.75 - 0.25 * (double)z));
        }
        WATERLOGGED = BlockStateProperties.field_208198_y;
        FACING = BlockStateProperties.field_208155_H;
        HORIZONTAL_FACING = DirectionProperty.func_177712_a((String)"horizontal", (Predicate)Direction.Plane.HORIZONTAL);
    }
}

