/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.client.renderer.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.itsmeow.whisperwoods.client.renderer.tile.model.ModelHGSkull;
import dev.itsmeow.whisperwoods.imdlib.block.BlockAnimalSkull;
import dev.itsmeow.whisperwoods.tileentity.TileEntityHGSkull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderHGSkull
extends TileEntityRenderer<TileEntityHGSkull> {
    private static final ModelHGSkull MODEL = new ModelHGSkull();
    private static final ResourceLocation TEXTURE = new ResourceLocation("whisperwoods", "textures/entity/hirschgeist_01.png");

    public RenderHGSkull(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityHGSkull te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState iblockstate = te.func_195044_w();
        if (iblockstate == null || !(iblockstate.func_177230_c() instanceof BlockAnimalSkull)) {
            return;
        }
        Direction enumfacing = te.getDirection();
        enumfacing = enumfacing == null ? Direction.NORTH : enumfacing;
        float rotation = -enumfacing.func_185119_l();
        rotation = enumfacing == Direction.NORTH || enumfacing == Direction.SOUTH ? enumfacing.func_176734_d().func_185119_l() : rotation;
        rotation = enumfacing == Direction.UP ? te.getTopRotation() : rotation;
        this.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, enumfacing, rotation);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, int packedOverlayIn, @Nullable Direction facing, float skullRotation) {
        matrixStackIn.func_227860_a_();
        RenderHGSkull.translateHead(matrixStackIn, facing, 1.32f);
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        float rotX = 0.0f;
        if (facing != null) {
            rotX = facing == Direction.UP ? 0.0f : 90.0f;
        }
        MODEL.func_225597_a_(null, skullRotation, rotX, 0.0f, 0.0f, 0.0f);
        MODEL.func_225598_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)TEXTURE)), packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    private static void translateHead(MatrixStack matrixStackIn, Direction face, float yOffset) {
        if (face == null) {
            matrixStackIn.func_227861_a_(0.5, (double)(0.25f + yOffset + 0.3f), 1.0);
            return;
        }
        switch (face) {
            case NORTH: {
                matrixStackIn.func_227861_a_(0.5, (double)(0.25f + yOffset + 0.3f), 1.0);
                break;
            }
            case EAST: {
                matrixStackIn.func_227861_a_(0.0, (double)(0.25f + yOffset + 0.3f), 0.5);
                break;
            }
            case SOUTH: {
                matrixStackIn.func_227861_a_(0.5, (double)(0.25f + yOffset + 0.3f), 0.0);
                break;
            }
            case WEST: {
                matrixStackIn.func_227861_a_(1.0, (double)(0.25f + yOffset + 0.3f), 0.5);
                break;
            }
            case UP: {
                matrixStackIn.func_227861_a_(0.5, (double)(0.18f + yOffset), 0.5);
                break;
            }
            default: {
                matrixStackIn.func_227861_a_(0.0, (double)(0.25f + yOffset + 0.3f), 0.5);
            }
        }
    }
}

