/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.entity;

import dev.itsmeow.whisperwoods.entity.EntityWisp;
import dev.itsmeow.whisperwoods.imdlib.entity.util.EntityTypeContainer;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.util.IOverrideCollisions;
import java.util.EnumSet;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityHirschgeist
extends MonsterEntity
implements IMob,
IOverrideCollisions<EntityHirschgeist> {
    protected int flameIndex = 0;
    public static final DataParameter<Float> DISTANCE_TO_TARGET = EntityDataManager.func_187226_a(EntityHirschgeist.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> DAYTIME = EntityDataManager.func_187226_a(EntityHirschgeist.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    private boolean wasSummoned = false;

    public EntityHirschgeist(World p_i48553_2_) {
        super(ModEntities.HIRSCHGEIST.entityType, p_i48553_2_);
        this.field_70728_aV = 150;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.7, true){

            public boolean func_75250_a() {
                return !EntityHirschgeist.this.isDaytime() && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return !EntityHirschgeist.this.isDaytime() && super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new FlameAttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new SummonWispsGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 20.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.65);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (reason == SpawnReason.EVENT || reason == SpawnReason.MOB_SUMMONED) {
            this.setWasSummoned();
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new GroundPathNavigator((MobEntity)this, worldIn){

            protected PathFinder func_179679_a(int i1) {
                this.field_179695_a = new WalkNodeProcessor(){

                    protected PathNodeType func_215744_a(IBlockReader reader, boolean b1, boolean b2, BlockPos pos, PathNodeType typeIn) {
                        return typeIn == PathNodeType.LEAVES || reader.func_180495_p(pos).func_177230_c().func_203417_a(BlockTags.field_200031_h) || reader.func_180495_p(pos).func_177230_c().func_203417_a(BlockTags.field_206952_E) ? PathNodeType.OPEN : super.func_215744_a(reader, b1, b2, pos, typeIn);
                    }
                };
                this.field_179695_a.func_186317_a(true);
                return new PathFinder(this.field_179695_a, i1);
            }

            public boolean func_179692_b(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3d vec, double p_179692_8_, double p_179692_10_) {
                for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)new BlockPos(x, y, z), (BlockPos)new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1))) {
                    double d0 = (double)blockpos.func_177958_n() + 0.5 - vec.field_72450_a;
                    double d1 = (double)blockpos.func_177952_p() + 0.5 - vec.field_72449_c;
                    BlockState state = this.field_75513_b.func_180495_p(blockpos);
                    if (d0 * p_179692_8_ + d1 * p_179692_10_ < 0.0 || state.func_196957_g((IBlockReader)this.field_75513_b, blockpos, PathType.LAND) || state.func_177230_c().func_203417_a(BlockTags.field_206952_E) && state.func_177230_c().func_203417_a(BlockTags.field_200031_h)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DISTANCE_TO_TARGET, (Object)Float.valueOf(-1.0f));
        this.func_184212_Q().func_187214_a(DAYTIME, (Object)true);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        if (compound.func_74767_n("summoned")) {
            this.setWasSummoned();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("summoned", this.wasSummoned());
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public float getTargetDistance() {
        return ((Float)this.func_184212_Q().func_187225_a(DISTANCE_TO_TARGET)).floatValue();
    }

    public int func_82166_i() {
        return 10;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_70653_a((Entity)this, 2.0f, this.func_226277_ct_() - entityIn.func_226277_ct_(), this.func_226281_cx_() - entityIn.func_226281_cx_());
                entityIn.func_70015_d(2 + this.func_70681_au().nextInt(2));
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFlameAnimationIndex() {
        return this.flameIndex;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 2 == 0) {
            this.flameIndex = this.flameIndex >= 7 ? 0 : ++this.flameIndex;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(DISTANCE_TO_TARGET, (Object)Float.valueOf(this.func_70638_az() == null ? -1.0f : this.func_70638_az().func_70032_d((Entity)this)));
            this.func_184212_Q().func_187227_b(DAYTIME, (Object)this.isDaytime());
        }
    }

    public boolean isDaytime() {
        return this.field_70170_p.func_72935_r();
    }

    public boolean isDaytimeClient() {
        return (Boolean)this.func_184212_Q().func_187225_a(DAYTIME);
    }

    public boolean func_190631_cK() {
        return !this.isDaytime();
    }

    public boolean func_190530_aW() {
        return this.isDaytime();
    }

    public boolean func_180431_b(DamageSource source) {
        return this.isDaytime() && source != DamageSource.field_76380_i && !source.func_180136_u() || source.func_76346_g() instanceof EntityHirschgeist || source == DamageSource.field_76376_m || source == DamageSource.field_76372_a || source == DamageSource.field_76370_b || source == DamageSource.field_76371_c;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.isDaytime() && !this.field_70170_p.field_72995_K && !source.func_180136_u() && source.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.whisperwoods.hirschgeist.message.invulnerable", new Object[0]));
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70624_b(LivingEntity entityIn) {
        super.func_70624_b(this.isDaytime() ? null : entityIn);
    }

    protected SoundEvent func_184639_G() {
        return this.func_70681_au().nextBoolean() ? SoundEvents.field_187858_fe : SoundEvents.field_219650_fj;
    }

    protected float func_70647_i() {
        return 0.3f;
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.5f, 0.6f);
    }

    public boolean func_70094_T() {
        if (this.field_70145_X) {
            return false;
        }
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (int i = 0; i < 8; ++i) {
                int j = MathHelper.func_76128_c((double)(this.func_226278_cu_() + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)this.func_70047_e()));
                int k = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)(((float)((i >> 1) % 2) - 0.5f) * this.func_213311_cf() * 0.8f)));
                int l = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)(((float)((i >> 2) % 2) - 0.5f) * this.func_213311_cf() * 0.8f)));
                if (blockpos$pooledmutable.func_177958_n() == k && blockpos$pooledmutable.func_177956_o() == j && blockpos$pooledmutable.func_177952_p() == l) continue;
                blockpos$pooledmutable.func_181079_c(k, j, l);
                BlockState state = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutable);
                if (!state.func_229980_m_((IBlockReader)this.field_70170_p, (BlockPos)blockpos$pooledmutable) || state.func_177230_c().func_203417_a(BlockTags.field_200031_h)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public Vec3d func_213306_e(Vec3d vec) {
        return this.allowedMove(vec);
    }

    @Override
    public Vec3d transformMove(@Nullable Entity entity, Vec3d vec, AxisAlignedBB bb, World world, ISelectionContext context, ReuseableStream<VoxelShape> stream) {
        boolean flag2;
        boolean flag = vec.field_72450_a == 0.0;
        boolean flag1 = vec.field_72448_b == 0.0;
        boolean bl = flag2 = vec.field_72449_c == 0.0;
        if (!(flag && flag1 || flag && flag2 || flag1 && flag2)) {
            ReuseableStream reusableStream = new ReuseableStream(Stream.concat(stream.func_212761_a(), world.func_226666_b_(entity, bb.func_216361_a(vec))).filter(shape -> {
                Block block = world.func_180495_p(new BlockPos(shape.func_197752_a().field_72340_a, shape.func_197752_a().field_72338_b, shape.func_197752_a().field_72339_c)).func_177230_c();
                return !block.func_203417_a(BlockTags.field_206952_E) && !block.func_203417_a(BlockTags.field_200031_h);
            }));
            return EntityHirschgeist.func_223310_a((Vec3d)vec, (AxisAlignedBB)bb, (ReuseableStream)reusableStream);
        }
        return EntityHirschgeist.func_213313_a((Vec3d)vec, (AxisAlignedBB)bb, (IWorldReader)world, (ISelectionContext)context, stream);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.despawn(distanceToClosestPlayer) && !this.wasSummoned();
    }

    public boolean wasSummoned() {
        return this.wasSummoned;
    }

    public void setWasSummoned() {
        this.wasSummoned = true;
    }

    @Override
    public EntityTypeContainer<?> getContainer() {
        return ModEntities.HIRSCHGEIST;
    }

    @Override
    public EntityHirschgeist getImplementation() {
        return this;
    }

    public static class SummonWispsGoal
    extends Goal {
        private final EntityHirschgeist parent;

        public SummonWispsGoal(EntityHirschgeist parent) {
            this.parent = parent;
        }

        public boolean func_75250_a() {
            return this.parent.func_70638_az() != null && this.parent.func_70681_au().nextInt(500) == 0 && this.parent.field_70170_p.func_175647_a(EntityWisp.class, this.parent.func_174813_aQ().func_186662_g(10.0), wisp -> wisp.isHirschgeistSummon()).size() == 0;
        }

        public void func_75249_e() {
            if (this.parent.field_70170_p instanceof ServerWorld) {
                for (int i = 0; i < 3; ++i) {
                    EntityWisp wisp = (EntityWisp)ModEntities.WISP.entityType.func_220349_b((World)((ServerWorld)this.parent.field_70170_p), null, null, null, this.parent.func_180425_c().func_177963_a((double)(this.parent.func_70681_au().nextInt(8) - 4) + 0.5, (double)(this.parent.func_70681_au().nextInt(4) + 1) + 0.5, (double)(this.parent.func_70681_au().nextInt(8) - 4) + 0.5), SpawnReason.REINFORCEMENT, false, false);
                    wisp.setHirschgeistSummon(true);
                    if (this.parent.func_70638_az() != null) {
                        wisp.func_70624_b(this.parent.func_70638_az());
                    }
                    this.parent.field_70170_p.func_217376_c((Entity)wisp);
                }
            }
        }

        public boolean func_75253_b() {
            return false;
        }
    }

    public static class FlameAttackGoal
    extends Goal {
        private int flameTicks;
        private final EntityHirschgeist attacker;
        private final World world;

        public FlameAttackGoal(EntityHirschgeist creature) {
            this.attacker = creature;
            this.world = creature.field_70170_p;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.attacker.func_70638_az() != null && !this.attacker.isDaytime() && this.attacker.func_70638_az().func_70089_S();
        }

        public boolean func_75253_b() {
            return this.flameTicks <= 200 && this.attacker.func_70638_az() != null;
        }

        public void func_75246_d() {
            ++this.flameTicks;
            LivingEntity target = this.attacker.func_70638_az();
            if (this.flameTicks == 10 && target != null && target.func_70068_e((Entity)this.attacker) <= 100.0) {
                AreaEffectCloudEntity areaEffectCloud = new AreaEffectCloudEntity(target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
                areaEffectCloud.func_184481_a((LivingEntity)this.attacker);
                areaEffectCloud.func_184483_a(3.0f);
                areaEffectCloud.func_184486_b(2000);
                areaEffectCloud.func_195059_a((IParticleData)ParticleTypes.field_197631_x);
                areaEffectCloud.func_184496_a(new EffectInstance(Effects.field_76433_i));
                this.attacker.field_70170_p.func_217376_c((Entity)areaEffectCloud);
            }
            if (this.world.field_72995_K) {
                this.doClientRenderEffects();
            }
        }

        public void doClientRenderEffects() {
            if (this.flameTicks % 2 == 0 && this.flameTicks < 10 && this.attacker.func_70638_az() != null) {
                LivingEntity target = this.attacker.func_70638_az();
                Vec3d vec3d = this.attacker.func_70676_i(1.0f).func_72432_b();
                vec3d.func_178785_b(-0.7853982f);
                double d0 = target.func_226277_ct_();
                double d1 = target.func_226278_cu_();
                double d2 = target.func_226281_cx_();
                for (int i = 0; i < 8; ++i) {
                    double d3 = d0 + this.attacker.func_70681_au().nextGaussian() / 2.0;
                    double d4 = d1 + this.attacker.func_70681_au().nextGaussian() / 2.0;
                    double d5 = d2 + this.attacker.func_70681_au().nextGaussian() / 2.0;
                    for (int j = 0; j < 6; ++j) {
                        this.attacker.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d3, d4, d5, -vec3d.field_72450_a * (double)0.08f * (double)j, -vec3d.field_72448_b * (double)0.6f, -vec3d.field_72449_c * (double)0.08f * (double)j);
                    }
                    vec3d.func_178785_b(0.19634955f);
                }
            }
        }

        public void func_75249_e() {
            this.flameTicks = 0;
        }
    }
}

