/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.entity;

import dev.itsmeow.whisperwoods.entity.EntityAnimalWithTypes;
import dev.itsmeow.whisperwoods.entity.EntityAnimalWithTypesAndSizeContainable;
import dev.itsmeow.whisperwoods.imdlib.entity.util.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.whisperwoods.init.ModEntities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TorchBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityMoth
extends EntityAnimalWithTypesAndSizeContainable {
    private static final DataParameter<Integer> LANDED = EntityDataManager.func_187226_a(EntityMoth.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final EntityPredicate playerPredicate = new EntityPredicate().func_221013_a(4.0).func_221011_b().func_221008_a();
    private BlockPos targetPosition;
    public static int MOTHS_REQUIRED_TO_DESTROY = 5;

    public EntityMoth(World worldIn) {
        this((EntityType<? extends EntityAnimalWithTypesAndSizeContainable>)ModEntities.MOTH.entityType, worldIn);
    }

    protected EntityMoth(EntityType<? extends EntityAnimalWithTypesAndSizeContainable> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LANDED, (Object)1);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    public boolean isLanded() {
        return (Integer)this.field_70180_af.func_187225_a(LANDED) != 1;
    }

    public int getLandedInteger() {
        return (Integer)this.field_70180_af.func_187225_a(LANDED);
    }

    public void setLanded(Direction direction) {
        if (direction == Direction.UP) {
            throw new RuntimeException("Invalid landing direction!");
        }
        this.field_70180_af.func_187227_b(LANDED, (Object)direction.ordinal());
    }

    public void setNotLanded() {
        this.field_70180_af.func_187227_b(LANDED, (Object)1);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isLanded()) {
            this.func_213317_d(Vec3d.field_186680_a);
            if (Direction.func_82600_a((int)this.getLandedInteger()) != Direction.DOWN) {
                double x = Math.floor(this.func_226277_ct_()) + 0.5;
                double z = Math.floor(this.func_226281_cx_()) + 0.5;
                BlockPos pos = new BlockPos(x, Math.floor(this.func_226278_cu_()) + 0.5, z);
                BlockPos offset = pos.func_177972_a(Direction.func_82600_a((int)this.getLandedInteger()));
                BlockPos diff = pos.func_177973_b((Vec3i)offset);
                this.func_70634_a(x - (double)diff.func_177958_n() / 2.778, Math.floor(this.func_226278_cu_()) + 0.5, z - (double)diff.func_177952_p() / 2.778);
                this.field_70177_z = 0.0f;
                this.field_70759_as = 0.0f;
            } else {
                this.func_70634_a(this.func_226277_ct_(), Math.floor(this.func_226278_cu_()), this.func_226281_cx_());
            }
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = this.func_180425_c();
        if (this.isLanded()) {
            BlockPos offset = blockpos.func_177972_a(Direction.func_82600_a((int)this.getLandedInteger()));
            if (this.field_70170_p.func_180495_p(offset).func_215686_e((IBlockReader)this.field_70170_p, offset)) {
                if (this.field_70170_p.func_217370_a(playerPredicate, (LivingEntity)this) != null || this.func_70681_au().nextInt(this.isAttractedToLight() ? 500 : 1000) == 0) {
                    this.setNotLanded();
                }
            } else {
                this.setNotLanded();
            }
        }
        if (this.targetPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.targetPosition.func_218137_a((IPosition)this.func_213303_ch(), 1.0) && !EntityMoth.isLightBlock(this.field_70170_p.func_180495_p(this.targetPosition))) {
            int i = 12;
            int j = 2;
            BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
            BlockPos destinationBlock = null;
            if (this.isAttractedToLight()) {
                int k = 0;
                while (k <= j) {
                    for (int l = 0; l < i; ++l) {
                        int i1 = 0;
                        while (i1 <= l) {
                            int j1;
                            int n = j1 = i1 < l && i1 > -l ? l : 0;
                            while (j1 <= l) {
                                blockpos$mutableblockpos.func_189533_g((Vec3i)this.func_180425_c()).func_196234_d(i1, k - 1, j1);
                                BlockState state = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos);
                                if (EntityMoth.isLightBlock(state) && (destinationBlock == null || state.func_185906_d() >= this.field_70170_p.func_180495_p(destinationBlock).func_185906_d())) {
                                    destinationBlock = blockpos$mutableblockpos.func_185334_h();
                                }
                                j1 = j1 > 0 ? -j1 : 1 - j1;
                            }
                            i1 = i1 > 0 ? -i1 : 1 - i1;
                        }
                    }
                    k = k > 0 ? -k : 1 - k;
                }
            }
            if (destinationBlock != null) {
                this.targetPosition = destinationBlock;
                this.setNotLanded();
            } else {
                boolean found = false;
                if (this.isAttractedToLight()) {
                    for (LivingEntity entity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(10.0))) {
                        for (Hand hand : Hand.values()) {
                            Item held = entity.func_184586_b(hand).func_77973_b();
                            if (held != Items.field_221657_bQ && held != Items.field_222111_pQ) continue;
                            this.targetPosition = entity.func_180425_c().func_177963_a(0.0, 1.5, 0.0);
                            found = true;
                            this.setNotLanded();
                        }
                    }
                }
                if (!found && this.field_70170_p.func_217370_a(playerPredicate, (LivingEntity)this) == null && this.func_70681_au().nextInt(this.isAttractedToLight() ? 80 : 30) == 0) {
                    for (Direction direction : Direction.values()) {
                        BlockPos offset;
                        if (direction == Direction.UP || !this.field_70170_p.func_180495_p(offset = blockpos.func_177972_a(direction)).func_215686_e((IBlockReader)this.field_70170_p, offset)) continue;
                        this.setLanded(direction);
                        this.targetPosition = null;
                        found = true;
                    }
                }
                if (!found) {
                    this.targetPosition = new BlockPos(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5), this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(4) - 1.0, this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5));
                }
            }
        }
        if (!this.isLanded() && this.targetPosition != null) {
            double d0 = (double)this.targetPosition.func_177958_n() + 0.5 - this.func_226277_ct_();
            double d1 = (double)this.targetPosition.func_177956_o() + 0.1 - this.func_226278_cu_();
            double d2 = (double)this.targetPosition.func_177952_p() + 0.5 - this.func_226281_cx_();
            Vec3d vec3d = this.func_213322_ci();
            Vec3d vec3d1 = vec3d.func_72441_c((Math.signum(d0) * 0.5 - vec3d.field_72450_a) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.field_72448_b) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.field_72449_c) * (double)0.1f);
            this.func_213317_d(vec3d1);
            float f = (float)(MathHelper.func_181159_b((double)vec3d1.field_72449_c, (double)vec3d1.field_72450_a) * 57.2957763671875) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += f1;
        }
        if (MOTHS_REQUIRED_TO_DESTROY != 0 && this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() instanceof TorchBlock && this.field_70170_p.func_217357_a(EntityMoth.class, this.func_174813_aQ()).size() >= MOTHS_REQUIRED_TO_DESTROY && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_180425_c());
            Block.func_220075_c((BlockState)state, (World)this.field_70170_p, (BlockPos)this.func_180425_c());
            this.field_70170_p.func_175656_a(this.func_180425_c(), Blocks.field_150350_a.func_176223_P());
        }
    }

    public boolean isAttractedToLight() {
        long time = this.field_70170_p.func_72820_D() % 24000L;
        return this.field_70170_p.func_226658_a_(LightType.SKY, this.func_180425_c()) < 10 || time >= 13000L && time <= 23000L;
    }

    private static boolean isLightBlock(BlockState blockState) {
        return blockState.func_185906_d() > 0;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isLanded()) {
            this.setNotLanded();
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(LANDED, (Object)compound.func_74762_e("Landed"));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Landed", ((Integer)this.field_70180_af.func_187225_a(LANDED)).intValue());
    }

    @Override
    protected float getRandomizedSize() {
        return ((float)this.field_70146_Z.nextInt(30) + 1.0f) / 100.0f + 0.15f;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    @Override
    public EntityTypeContainer<?> getContainer() {
        return ModEntities.MOTH;
    }

    @Override
    protected EntityAnimalWithTypes getBaseChild() {
        return null;
    }

    @Override
    public EntityTypeContainerContainable<?, ?> getContainableContainer() {
        return ModEntities.MOTH;
    }

    public static void bottleTooltip(EntityTypeContainer<? extends MobEntity> container, ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("SizeTag", 5)) {
            tooltip.add(new StringTextComponent("Size: " + tag.func_74760_g("SizeTag")).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true))));
        }
    }
}

