/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import dev.itsmeow.whisperwoods.entity.EntityHirschgeist;
import dev.itsmeow.whisperwoods.imdlib.entity.util.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.IContainerEntity;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.init.ModItems;
import dev.itsmeow.whisperwoods.network.WWNetwork;
import dev.itsmeow.whisperwoods.network.WispAttackPacket;
import dev.itsmeow.whisperwoods.util.WispColors;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntityWisp
extends AnimalEntity
implements IContainerEntity<EntityWisp> {
    public final DamageSource WISP = new EntityDamageSource("wisp", (Entity)this).func_151518_m().func_76348_h();
    public static int HOSTILE_CHANCE = 8;
    public boolean isHostile = false;
    public long lastSpawn = 0L;
    private BlockPos targetPosition;
    public static final DataParameter<Integer> ATTACK_STATE = EntityDataManager.func_187226_a(EntityWisp.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<String> TARGET_ID = EntityDataManager.func_187226_a(EntityWisp.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> TARGET_NAME = EntityDataManager.func_187226_a(EntityWisp.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Float> PASSIVE_SCALE = EntityDataManager.func_187226_a(EntityWisp.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Integer> COLOR_VARIANT = EntityDataManager.func_187226_a(EntityWisp.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final EntityPredicate PASSIVE_SCALE_PREDICATE = new EntityPredicate().func_221008_a().func_221011_b().func_221009_d();
    private static final EntityPredicate HOSTILE_TARGET_PREDICATE = EntityPredicate.field_221016_a.func_221012_a(e -> EntityPredicates.field_188444_d.test(e) && e.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() != ModItems.HIRSCHGEIST_SKULL.get());
    protected ResourceLocation targetTexture;
    private boolean shouldBeHostile = false;
    private int attackCooldown = 0;
    private boolean isHirschgeistSummon = false;

    protected EntityWisp(EntityType<? extends EntityWisp> entityType, World world) {
        super(entityType, world);
    }

    public EntityWisp(World world) {
        this(ModEntities.WISP.entityType, world);
    }

    public WispColors.WispColor getWispColor() {
        int c = (Integer)this.field_70180_af.func_187225_a(COLOR_VARIANT);
        if (c <= WispColors.values().length && c > 0) {
            return WispColors.values()[c - 1];
        }
        return WispColors.BLUE;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.5);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_STATE, (Object)0);
        this.field_70180_af.func_187214_a(TARGET_ID, (Object)"");
        this.field_70180_af.func_187214_a(TARGET_NAME, (Object)"");
        this.field_70180_af.func_187214_a(PASSIVE_SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_VARIANT, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isHostile && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.isHostile = false;
            this.shouldBeHostile = true;
        } else if (this.shouldBeHostile && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
            this.isHostile = true;
            this.shouldBeHostile = false;
        }
        int state = (Integer)this.field_70180_af.func_187225_a(ATTACK_STATE);
        if (!this.hasSoul()) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 0.6, 0.5));
            this.field_70145_X = false;
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
            this.field_70145_X = true;
            this.field_70180_af.func_187227_b(ATTACK_STATE, (Object)(state + 1));
        }
        if (this.func_70638_az() != null && !HOSTILE_TARGET_PREDICATE.func_221015_a((LivingEntity)this, this.func_70638_az())) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K && this.isHirschgeistSummon() && this.func_70638_az() != null) {
            double distance = this.func_70032_d((Entity)this.func_70638_az());
            if (this.attackCooldown <= 0) {
                if (distance < 10.0) {
                    WWNetwork.HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new WispAttackPacket(this.func_213303_ch().func_72441_c(0.0, (double)this.func_213302_cg(), 0.0), this.getWispColor().getColor()));
                    this.func_70638_az().func_70097_a(DamageSource.field_76376_m, 1.0f);
                    this.attackCooldown = 40 + this.func_70681_au().nextInt(6);
                }
            } else {
                --this.attackCooldown;
            }
        }
        if (state == 400 && !this.field_70170_p.field_72995_K && this.field_70170_p.func_73046_m() != null) {
            PlayerEntity soul = null;
            if (this.func_70638_az() instanceof PlayerEntity) {
                soul = (PlayerEntity)this.func_70638_az();
            }
            if (soul == null) {
                soul = this.field_70170_p.func_73046_m().func_184103_al().func_177451_a(UUID.fromString((String)this.field_70180_af.func_187225_a(TARGET_ID)));
            }
            if (soul == null) {
                soul = this.field_70170_p.func_73046_m().func_184103_al().func_152612_a((String)this.field_70180_af.func_187225_a(TARGET_NAME));
            }
            this.resetAttackState();
            if (soul != null && HOSTILE_TARGET_PREDICATE.func_221015_a((LivingEntity)this, (LivingEntity)soul)) {
                soul.func_70097_a(this.WISP, 3000.0f);
            }
            this.targetPosition = null;
            this.func_70624_b(null);
        }
        if (this.isPassive() && !this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(10.0)).size() > 0) {
                PlayerEntity nearest = (PlayerEntity)this.field_70170_p.func_217360_a(PlayerEntity.class, PASSIVE_SCALE_PREDICATE, null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_174813_aQ().func_186662_g(10.0));
                if (nearest != null) {
                    this.field_70180_af.func_187227_b(PASSIVE_SCALE, (Object)Float.valueOf(nearest.func_70032_d((Entity)this) / 12.0f));
                } else {
                    this.field_70180_af.func_187227_b(PASSIVE_SCALE, (Object)Float.valueOf(0.3f));
                }
            } else {
                this.field_70180_af.func_187227_b(PASSIVE_SCALE, (Object)Float.valueOf(1.0f));
            }
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source.func_76346_g() == this || source == DamageSource.field_76376_m || source == DamageSource.field_76372_a || source == DamageSource.field_76370_b || source.func_76346_g() instanceof EntityHirschgeist;
    }

    public boolean isPassive() {
        return !this.isHostile && !this.isHirschgeistSummon();
    }

    public boolean isHirschgeistSummon() {
        return this.isHirschgeistSummon;
    }

    public void setHirschgeistSummon(boolean value) {
        this.isHirschgeistSummon = value;
        this.isHostile = false;
        this.shouldBeHostile = false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null && this.func_70638_az().func_190530_aW()) {
            this.func_70624_b(null);
        }
        if (this.targetPosition != null && this.func_180425_c().func_177951_i((Vec3i)this.targetPosition) < 4.0 || this.targetPosition == null || !this.isHostile || !this.hasSoul() || this.isHirschgeistSummon()) {
            if (this.func_70638_az() == null && !this.isPassive()) {
                this.func_70624_b(this.field_70170_p.func_217360_a(PlayerEntity.class, HOSTILE_TARGET_PREDICATE, null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_174813_aQ().func_186662_g(25.0)));
            }
            this.targetPosition = !this.isPassive() && this.func_70638_az() != null ? this.func_70638_az().func_180425_c() : new BlockPos(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5), this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(4) - 0.1, this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5));
            if (this.hasSoul() && this.isHostile) {
                this.targetPosition = new BlockPos(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(60) - (double)this.field_70146_Z.nextInt(60), this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(4), this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(60) - (double)this.field_70146_Z.nextInt(60));
            }
        }
        if (this.targetPosition != null) {
            double d0 = (double)this.targetPosition.func_177958_n() + 0.5 - this.func_226277_ct_();
            double d1 = (double)this.targetPosition.func_177956_o() + 0.1 - this.func_226278_cu_();
            double d2 = (double)this.targetPosition.func_177952_p() + 0.5 - this.func_226281_cx_();
            Vec3d vec3d = this.func_213322_ci();
            Vec3d vec3d1 = vec3d.func_72441_c((Math.signum(d0) * 0.5 - vec3d.field_72450_a) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.field_72448_b) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.field_72449_c) * (double)0.1f);
            this.func_213317_d(vec3d1);
            float f = (float)(MathHelper.func_181159_b((double)vec3d1.field_72449_c, (double)vec3d1.field_72450_a) * 57.2957763671875) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += f1;
        }
    }

    public boolean hasSoul() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_STATE) > 0;
    }

    protected void resetAttackState() {
        this.field_70180_af.func_187227_b(ATTACK_STATE, (Object)0);
        this.field_70180_af.func_187227_b(TARGET_ID, (Object)"");
        this.field_70180_af.func_187227_b(TARGET_NAME, (Object)"");
        this.targetTexture = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTargetTexture() {
        if (this.targetTexture == null) {
            UUID target = UUID.fromString((String)this.func_184212_Q().func_187225_a(TARGET_ID));
            String name = (String)this.func_184212_Q().func_187225_a(TARGET_NAME);
            GameProfile profile = new GameProfile(target, name);
            if ((profile = SkullTileEntity.func_174884_b((GameProfile)profile)) != null) {
                ResourceLocation skin;
                Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(profile);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    skin = Minecraft.func_71410_x().func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                } else {
                    skin = DefaultPlayerSkin.func_177334_a((UUID)target);
                    Minecraft.func_71410_x().func_152342_ad().func_152790_a(profile, null, false);
                }
                this.targetTexture = skin;
            }
        }
        return this.targetTexture;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    protected void func_82167_n(Entity entity) {
        if (entity == this.func_70638_az() && this.func_70638_az() != null && entity instanceof PlayerEntity && HOSTILE_TARGET_PREDICATE.func_221015_a((LivingEntity)this, (LivingEntity)((PlayerEntity)entity)) && !this.hasSoul() && !this.isHirschgeistSummon()) {
            PlayerEntity player = (PlayerEntity)entity;
            this.field_70180_af.func_187227_b(ATTACK_STATE, (Object)1);
            this.field_70180_af.func_187227_b(TARGET_ID, (Object)player.func_146103_bH().getId().toString());
            this.field_70180_af.func_187227_b(TARGET_NAME, (Object)player.func_146103_bH().getName());
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public boolean func_213397_c(double range) {
        return this.getContainer().despawn && !this.hasSoul();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("is_hostile", this.isHostile);
        compound.func_74768_a("color_variant", ((Integer)this.field_70180_af.func_187225_a(COLOR_VARIANT)).intValue());
        compound.func_74757_a("should_be_hostile", this.shouldBeHostile);
        compound.func_74757_a("hirschgeist_summon", this.isHirschgeistSummon());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.isHostile = compound.func_74767_n("is_hostile");
        this.field_70180_af.func_187227_b(COLOR_VARIANT, (Object)compound.func_74762_e("color_variant"));
        this.shouldBeHostile = compound.func_74767_n("should_be_hostile");
        this.setHirschgeistSummon(compound.func_74767_n("hirschgeist_summon"));
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && (this.field_70146_Z.nextInt(10) == 0 || this.hasSoul() || this.isHirschgeistSummon())) {
            ItemStack stack = new ItemStack((IItemProvider)EntityWisp.getItemForVariant((Integer)this.func_184212_Q().func_187225_a(COLOR_VARIANT)));
            this.func_70099_a(stack, 0.5f);
        }
    }

    private static Item getItemForVariant(int variant) {
        if (variant <= WispColors.values().length && variant > 0) {
            Block block = (Block)WispColors.values()[variant - 1].getGhostLight().get();
            return block.func_199767_j();
        }
        return null;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, CompoundNBT compound) {
        boolean hostile = this.func_70681_au().nextInt(HOSTILE_CHANCE) == 0;
        int colorVariant = this.func_70681_au().nextInt(WispColors.values().length) + 1;
        if (livingdata instanceof WispData) {
            hostile = ((WispData)((Object)livingdata)).isHostile;
            colorVariant = ((WispData)((Object)livingdata)).colorVariant;
        } else {
            livingdata = new WispData(hostile, colorVariant);
        }
        this.isHostile = hostile;
        this.field_70180_af.func_187227_b(COLOR_VARIANT, (Object)colorVariant);
        return livingdata;
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    @Override
    public EntityWisp getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainer<?> getContainer() {
        return ModEntities.WISP;
    }

    public static class WispData
    extends AgeableEntity.AgeableData {
        public boolean isHostile;
        public int colorVariant;

        public WispData(boolean isHostile, int colorVariant) {
            this.isHostile = isHostile;
            this.colorVariant = colorVariant;
        }
    }
}

