/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.itsmeow.whisperwoods.imdlib.client.render.BaseRenderer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.IVariantTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class ImplRenderer<T extends MobEntity, A extends EntityModel<T>>
extends BaseRenderer<T, A> {
    private final TextureContainer<T, A> textureContainer;
    private final ModelContainer<T, A> modelContainer;
    private final PreRenderCallback<T> preRenderCallback;
    private final HandleRotation<T> handleRotation;
    private final ApplyRotations<T> applyRotations;
    private final SuperCallApplyRotations applyRotationsSuper;
    private final RenderLayer<T> renderLayer;

    public ImplRenderer(EntityRendererManager mgr, float shadow, @Nonnull TextureContainer<T, A> textureContainer, @Nonnull ModelContainer<T, A> modelContainer, @Nullable PreRenderCallback<T> preRenderCallback, @Nullable HandleRotation<T> handleRotation, @Nullable ApplyRotations<T> applyRotations, SuperCallApplyRotations applyRotationsSuper, RenderLayer<T> renderLayer) {
        super(mgr, modelContainer.getBaseModel(), shadow);
        this.textureContainer = textureContainer;
        this.modelContainer = modelContainer;
        this.preRenderCallback = preRenderCallback;
        this.handleRotation = handleRotation;
        this.applyRotations = applyRotations;
        this.applyRotationsSuper = applyRotationsSuper;
        this.renderLayer = renderLayer;
    }

    protected void applyRotations(T e, MatrixStack s, float a, float y, float p) {
        if (this.applyRotations == null) {
            super.func_225621_a_(e, s, a, y, p);
        } else {
            if (this.applyRotationsSuper == SuperCallApplyRotations.PRE) {
                super.func_225621_a_(e, s, a, y, p);
            }
            this.applyRotations.applyRotations(e, s, a, y, p);
            if (this.applyRotationsSuper == SuperCallApplyRotations.POST) {
                super.func_225621_a_(e, s, a, y, p);
            }
        }
    }

    protected void preRenderCallback(T e, MatrixStack s, float p) {
        if (this.preRenderCallback != null) {
            this.preRenderCallback.preRenderCallback(e, s, p);
        }
    }

    protected float handleRotationFloat(T e, float p) {
        return this.handleRotation == null ? super.func_77044_a(e, p) : this.handleRotation.handleRotation(e, p);
    }

    protected RenderType func_230042_a_(T entity, boolean visible, boolean visibleToPlayer) {
        return this.renderLayer == null ? super.func_230042_a_(entity, visible, visibleToPlayer) : this.renderLayer.renderLayer(entity, visible, visibleToPlayer, this.getEntityTexture(entity));
    }

    public void func_225623_a_(T e, float p_225623_2_, float p_225623_3_, MatrixStack p_225623_4_, IRenderTypeBuffer p_225623_5_, int p_225623_6_) {
        this.field_77045_g = this.modelContainer.getModel(e);
        super.func_225623_a_(e, p_225623_2_, p_225623_3_, p_225623_4_, p_225623_5_, p_225623_6_);
    }

    public ResourceLocation getEntityTexture(T entity) {
        return this.textureContainer.getTexture(entity);
    }

    public static <T extends MobEntity, A extends EntityModel<T>> Builder<T, A> factory(String modid, float shadow) {
        return new Builder(modid, shadow);
    }

    private static ResourceLocation tex(String modid, String location) {
        return new ResourceLocation(modid, "textures/entity/" + location + ".png");
    }

    @FunctionalInterface
    public static interface RenderDef<T extends MobEntity, A extends EntityModel<T>> {
        public Builder<T, A> apply(Builder<T, A> var1);
    }

    @FunctionalInterface
    public static interface RenderLayer<T extends MobEntity> {
        public RenderType renderLayer(T var1, boolean var2, boolean var3, ResourceLocation var4);
    }

    @FunctionalInterface
    public static interface ApplyRotations<T extends MobEntity> {
        public void applyRotations(T var1, MatrixStack var2, float var3, float var4, float var5);
    }

    @FunctionalInterface
    public static interface HandleRotation<T extends MobEntity> {
        public float handleRotation(T var1, float var2);
    }

    @FunctionalInterface
    public static interface PreRenderCallback<T extends MobEntity> {
        public void preRenderCallback(T var1, MatrixStack var2, float var3);
    }

    public static class Builder<T extends MobEntity, A extends EntityModel<T>> {
        private final String modid;
        private final float shadow;
        private TextureContainer<T, A> tex;
        private ModelContainer<T, A> model;
        private PreRenderCallback<T> preRender;
        private ArrayList<Function<BaseRenderer<T, A>, LayerRenderer<T, A>>> layers = new ArrayList();
        private HandleRotation<T> handleRotation;
        private ApplyRotations<T> applyRotations;
        private SuperCallApplyRotations superCallApplyRotations = SuperCallApplyRotations.NONE;
        private Map<String, ResourceLocation> texMapper = new HashMap<String, ResourceLocation>();
        private Map<Class<? extends EntityModel<T>>, EntityModel<T>> modelMapper = new HashMap<Class<? extends EntityModel<T>>, EntityModel<T>>();
        private RenderLayer<T> renderLayer;

        protected Builder(String modid, float shadow) {
            this.modid = modid;
            this.shadow = shadow;
        }

        public Builder<T, A> layer(Function<BaseRenderer<T, A>, LayerRenderer<T, A>> layer) {
            this.layers.add(layer);
            return this;
        }

        public Builder<T, A> tSingle(String texture) {
            this.tex = new TextureContainer(ImplRenderer.tex(this.modid, texture));
            return this;
        }

        public Builder<T, A> tCondition(Predicate<T> condition, String trueTex, String falseTex) {
            this.tex = new TextureContainer(condition, ImplRenderer.tex(this.modid, trueTex), ImplRenderer.tex(this.modid, falseTex));
            return this;
        }

        public Builder<T, A> tMapped(Function<T, String> texMapper) {
            this.tex = new TextureContainer(entity -> this.texStored((String)texMapper.apply(entity)));
            return this;
        }

        public Builder<T, A> tSingleRaw(ResourceLocation texture) {
            this.tex = new TextureContainer(texture);
            return this;
        }

        public Builder<T, A> tConditionRaw(Predicate<T> condition, ResourceLocation trueTex, ResourceLocation falseTex) {
            this.tex = new TextureContainer(condition, trueTex, falseTex);
            return this;
        }

        public Builder<T, A> tMappedRaw(Function<T, ResourceLocation> texMapper) {
            this.tex = new TextureContainer(texMapper);
            return this;
        }

        public Builder<T, A> tVariant() {
            return this.tMappedRaw(e -> {
                if (e instanceof IVariantTypes) {
                    return ((IVariantTypes)e).getVariantTextureOrNull();
                }
                return null;
            });
        }

        public Builder<T, A> tMappedConditionRaw(Predicate<T> condition, Function<T, ResourceLocation> texMapper, String conditionTex) {
            return this.tMappedConditionRaw(condition, texMapper, ImplRenderer.tex(this.modid, conditionTex));
        }

        public Builder<T, A> tMappedConditionRaw(Predicate<T> condition, Function<T, ResourceLocation> texMapper, ResourceLocation conditionTex) {
            this.tex = new TextureContainer(condition, texMapper, conditionTex);
            return this;
        }

        public Builder<T, A> tVariantCondition(Predicate<T> condition, Function<T, ResourceLocation> texMapper, String conditionTex) {
            return this.tVariantCondition(condition, texMapper, ImplRenderer.tex(this.modid, conditionTex));
        }

        public Builder<T, A> tVariantCondition(Predicate<T> condition, Function<T, ResourceLocation> texMapper, ResourceLocation conditionTex) {
            this.tex = new TextureContainer(condition, e -> {
                if (e instanceof IVariantTypes) {
                    return ((IVariantTypes)e).getVariantTextureOrNull();
                }
                return null;
            }, conditionTex);
            return this;
        }

        public Builder<T, A> tBabyVariant(String babyTex) {
            return this.tVariantCondition((T e) -> {
                if (e instanceof AgeableEntity) {
                    return e.func_70631_g_();
                }
                return false;
            }, (T e) -> {
                if (e instanceof IVariantTypes) {
                    return ((IVariantTypes)e).getVariantTextureOrNull();
                }
                return null;
            }, ImplRenderer.tex(this.modid, babyTex));
        }

        public Builder<T, A> mSingle(A model) {
            this.model = new ModelContainer(model);
            return this;
        }

        public Builder<T, A> mMapped(Function<T, Class<? extends EntityModel<T>>> modelMapper, A baseModel) {
            this.model = new ModelContainer<MobEntity, A>(e -> this.modelStored((Class)modelMapper.apply(e), baseModel), baseModel);
            return this;
        }

        public Builder<T, A> mCondition(Predicate<T> condition, A trueModel, EntityModel<T> falseModel) {
            this.model = new ModelContainer<T, A>(condition, trueModel, falseModel);
            return this;
        }

        public Builder<T, A> preRender(PreRenderCallback<T> preRender) {
            this.preRender = preRender;
            return this;
        }

        public Builder<T, A> simpleScale(Function<T, Float> function) {
            this.preRender((e, s, p) -> {
                float scale = ((Float)function.apply(e)).floatValue();
                s.func_227862_a_(scale, scale, scale);
            });
            return this;
        }

        public Builder<T, A> condScale(Predicate<T> cond, float xScale, float yScale, float zScale) {
            this.preRender((e, s, p) -> {
                if (cond.test(e)) {
                    s.func_227862_a_(xScale, yScale, zScale);
                }
            });
            return this;
        }

        public Builder<T, A> condScale(Predicate<T> cond, float scale) {
            return this.condScale(cond, scale, scale, scale);
        }

        public Builder<T, A> condDualScale(Predicate<T> cond, float truexScale, float trueyScale, float truezScale, float falsexScale, float falseyScale, float falsezScale) {
            this.preRender((e, s, p) -> {
                if (cond.test(e)) {
                    s.func_227862_a_(truexScale, trueyScale, truezScale);
                } else {
                    s.func_227862_a_(falsexScale, falseyScale, falsezScale);
                }
            });
            return this;
        }

        public Builder<T, A> condDualScale(Predicate<T> cond, float trueScale, float falseScale) {
            return this.condDualScale(cond, trueScale, trueScale, trueScale, falseScale, falseScale, falseScale);
        }

        public Builder<T, A> childScale(float xScale, float yScale, float zScale) {
            this.preRender((e, s, p) -> {
                if (e instanceof AgeableEntity && e.func_70631_g_()) {
                    s.func_227862_a_(xScale, yScale, zScale);
                }
            });
            return this;
        }

        public Builder<T, A> childScale(float scale) {
            return this.childScale(scale, scale, scale);
        }

        public Builder<T, A> ageScale(float adultxScale, float adultyScale, float adultzScale, float childxScale, float childyScale, float childzScale) {
            this.preRender((e, s, p) -> {
                if (e instanceof AgeableEntity) {
                    if (e.func_70631_g_()) {
                        s.func_227862_a_(childxScale, childyScale, childzScale);
                    } else {
                        s.func_227862_a_(adultxScale, adultyScale, adultzScale);
                    }
                }
            });
            return this;
        }

        public Builder<T, A> ageScale(float adultScale, float childScale) {
            return this.ageScale(adultScale, adultScale, adultScale, childScale, childScale, childScale);
        }

        public Builder<T, A> handleRotation(HandleRotation<T> handleRotationFunc) {
            this.handleRotation = handleRotationFunc;
            return this;
        }

        public Builder<T, A> applyRotations(ApplyRotations<T> applyRotationsFunc, SuperCallApplyRotations superCall) {
            this.superCallApplyRotations = superCall;
            return this.applyRotations(applyRotationsFunc);
        }

        public Builder<T, A> applyRotations(ApplyRotations<T> applyRotationsFunc) {
            this.applyRotations = applyRotationsFunc;
            return this;
        }

        public Builder<T, A> renderLayer(RenderLayer<T> renderLayerFunc) {
            this.renderLayer = renderLayerFunc;
            return this;
        }

        public IRenderFactory<T> done() {
            if (this.tex == null || this.model == null) {
                throw new IllegalArgumentException("Must define both a texture and a model before calling build()!");
            }
            return mgr -> new ImplRenderer<T, A>(mgr, this.shadow, this.tex, this.model, this.preRender, this.handleRotation, this.applyRotations, this.superCallApplyRotations, this.renderLayer).layers(this.layers);
        }

        private ResourceLocation texStored(String location) {
            return this.texMapper.computeIfAbsent(location, l -> ImplRenderer.tex(this.modid, l));
        }

        private EntityModel<T> modelStored(Class<? extends EntityModel<T>> clazz, A defaultModel) {
            return this.modelMapper.computeIfAbsent(clazz, l -> {
                try {
                    return (EntityModel)clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                    return defaultModel;
                }
            });
        }
    }

    public static enum SuperCallApplyRotations {
        PRE,
        NONE,
        POST;

    }

    public static enum Strategy {
        SINGLE,
        MAPPER,
        MAPPER_CONDITION,
        CONDITION;

    }

    public static class ModelContainer<T extends MobEntity, A extends EntityModel<T>> {
        private final Strategy strategy;
        private final A baseModel;
        private Function<T, EntityModel<T>> modelMapper;
        private A trueModel;
        private EntityModel<T> falseModel;
        private Predicate<T> condition;
        private EntityModel<T> conditionModel;

        public ModelContainer(A baseModel) {
            this.strategy = Strategy.SINGLE;
            this.baseModel = baseModel;
        }

        public ModelContainer(Function<T, EntityModel<T>> modelMapper, A baseModel) {
            this.strategy = Strategy.MAPPER;
            this.modelMapper = modelMapper;
            this.baseModel = baseModel;
        }

        public ModelContainer(Predicate<T> condition, Function<T, EntityModel<T>> modelMapper, A baseModel, EntityModel<T> conditionModel) {
            this.strategy = Strategy.MAPPER;
            this.modelMapper = modelMapper;
            this.baseModel = baseModel;
            this.conditionModel = conditionModel;
            this.condition = condition;
        }

        public ModelContainer(Predicate<T> condition, A trueModel, EntityModel<T> falseModel) {
            this.strategy = Strategy.CONDITION;
            this.condition = condition;
            this.trueModel = trueModel;
            this.falseModel = falseModel;
            this.baseModel = trueModel;
        }

        public EntityModel<T> getModel(T entity) {
            switch (this.strategy) {
                case SINGLE: {
                    return this.baseModel;
                }
                case MAPPER: {
                    return this.modelMapper.apply(entity);
                }
                case CONDITION: {
                    return this.condition.test(entity) ? this.trueModel : this.falseModel;
                }
                case MAPPER_CONDITION: {
                    return this.condition.test(entity) ? this.conditionModel : this.modelMapper.apply(entity);
                }
            }
            return null;
        }

        public A getBaseModel() {
            return this.baseModel;
        }
    }

    public static class TextureContainer<T extends MobEntity, A extends EntityModel<T>> {
        private Strategy strategy;
        private ResourceLocation singleTexture;
        private Function<T, ResourceLocation> texMapper;
        private ResourceLocation trueTex;
        private ResourceLocation falseTex;
        private Predicate<T> condition;
        private ResourceLocation conditionTex;

        public TextureContainer(ResourceLocation singleTexture) {
            this.strategy = Strategy.SINGLE;
            this.singleTexture = singleTexture;
        }

        public TextureContainer(Function<T, ResourceLocation> texMapper) {
            this.strategy = Strategy.MAPPER;
            this.texMapper = texMapper;
        }

        public TextureContainer(Predicate<T> condition, Function<T, ResourceLocation> texMapper, ResourceLocation conditionTex) {
            this.strategy = Strategy.MAPPER_CONDITION;
            this.texMapper = texMapper;
            this.condition = condition;
            this.conditionTex = conditionTex;
        }

        public TextureContainer(Predicate<T> condition, ResourceLocation trueTex, ResourceLocation falseTex) {
            this.strategy = Strategy.CONDITION;
            this.condition = condition;
            this.trueTex = trueTex;
            this.falseTex = falseTex;
        }

        public ResourceLocation getTexture(T entity) {
            switch (this.strategy) {
                case SINGLE: {
                    return this.singleTexture;
                }
                case MAPPER: {
                    return this.texMapper.apply(entity);
                }
                case CONDITION: {
                    return this.condition.test(entity) ? this.trueTex : this.falseTex;
                }
                case MAPPER_CONDITION: {
                    return this.condition.test(entity) ? this.conditionTex : this.texMapper.apply(entity);
                }
            }
            return null;
        }
    }
}

