/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.client.util;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.itsmeow.whisperwoods.imdlib.client.render.ImplRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelReplacementHandler {
    public final Logger LOG = LogManager.getLogger();
    protected Map<RegistrationTime, Multimap<Pair<String, String>, Supplier<Supplier<ReplaceDefinition<?>>>>> replaceDefs = new HashMap();
    protected Map<RegistrationTime, Multimap<String, Supplier<Runnable>>> modActions = new HashMap<RegistrationTime, Multimap<String, Supplier<Runnable>>>();
    public final String parent_modid;
    protected ReplacementConfig config;

    public ModelReplacementHandler(String modid) {
        this.parent_modid = modid;
    }

    public ReplacementConfig getConfig(ForgeConfigSpec.Builder builder) {
        return this.getConfig(builder, (a, b) -> {});
    }

    public ReplacementConfig getConfig(ForgeConfigSpec.Builder builder, BiConsumer<ForgeConfigSpec.Builder, Map<String, Map<String, ForgeConfigSpec.BooleanValue>>> manuals) {
        this.config = new ReplacementConfig(this, builder, manuals);
        return this.config;
    }

    public void mre() {
        this.runActions(RegistrationTime.MODELREGISTRY);
        this.overwriteRenders(RegistrationTime.MODELREGISTRY);
    }

    public void clientSetup() {
        this.runActions(RegistrationTime.CLIENTSETUP);
        this.overwriteRenders(RegistrationTime.CLIENTSETUP);
    }

    public void addReplace(RegistrationTime time, String modid, String name, Supplier<Supplier<ReplaceDefinition<?>>> definition) {
        this.replaceDefs.putIfAbsent(time, (Multimap<Pair<String, String>, Supplier<Supplier<ReplaceDefinition<?>>>>)MultimapBuilder.hashKeys().linkedHashSetValues().build());
        this.replaceDefs.get((Object)time).put((Object)Pair.of((Object)modid, (Object)name), definition);
        this.LOG.debug(String.format("[%s] Registering replace for %s from %s at %s", this.parent_modid, name, modid, time.name()));
    }

    public void addAction(RegistrationTime time, String modid, Supplier<Runnable> action) {
        this.modActions.putIfAbsent(time, (Multimap<String, Supplier<Runnable>>)MultimapBuilder.hashKeys().linkedHashSetValues().build());
        this.modActions.get((Object)time).put((Object)modid, action);
        this.LOG.debug(String.format("[%s] Registering action for %s at %s", this.parent_modid, modid, time.name()));
    }

    public boolean getEnabledAndLoaded(String mod, String override) {
        Map<String, ForgeConfigSpec.BooleanValue> overrides = this.config.replace_config.getModsMap().get(mod);
        if (overrides == null) {
            return false;
        }
        return overrides.containsKey(override) ? (Boolean)overrides.get(override).get() : false;
    }

    protected void overwriteRenders(RegistrationTime phase) {
        this.replaceDefs.putIfAbsent(phase, (Multimap<Pair<String, String>, Supplier<Supplier<ReplaceDefinition<?>>>>)MultimapBuilder.hashKeys().hashSetValues().build());
        this.replaceDefs.get((Object)phase).forEach((pair, definitionSupplier) -> {
            boolean doReplace = this.getEnabledAndLoaded((String)pair.getLeft(), (String)pair.getRight());
            if (ModList.get().isLoaded((String)pair.getLeft()) || ((String)pair.getLeft()).equals("minecraft")) {
                final ReplaceDefinition def = (ReplaceDefinition)((Supplier)definitionSupplier.get()).get();
                if (doReplace) {
                    IRenderFactory<LivingEntity> factory = new IRenderFactory<LivingEntity>(){

                        public EntityRenderer<LivingEntity> createRenderFor(EntityRendererManager manager) {
                            return def.factory.createRenderFor(manager);
                        }
                    };
                    RenderingRegistry.registerEntityRenderingHandler(def.type, (IRenderFactory)factory);
                    this.LOG.debug(String.format("[%s] Overriding %s / %s in %s", this.parent_modid, pair.getRight(), def.type.func_212546_e(), pair.getLeft()));
                } else {
                    this.LOG.debug(String.format("[%s] Was going to override %s / %s in %s, but it is disabled!", this.parent_modid, pair.getRight(), def.type.func_212546_e(), pair.getLeft()));
                }
            } else {
                this.LOG.debug(String.format("[%s] %s was not replaced, because %s is not loaded! Config %s", this.parent_modid, pair.getRight(), pair.getLeft(), doReplace));
            }
        });
    }

    protected void runActions(RegistrationTime phase) {
        this.modActions.putIfAbsent(phase, (Multimap<String, Supplier<Runnable>>)MultimapBuilder.hashKeys().hashSetValues().build());
        this.modActions.get((Object)phase).forEach((modid, action) -> {
            if (ModList.get().isLoaded(modid) || modid.equals("minecraft")) {
                ((Runnable)action.get()).run();
                this.LOG.debug(String.format("[%s] Running action for %s", this.parent_modid, modid));
            } else {
                this.LOG.debug(String.format("[%s] No action executed for %s, as it is not loaded.", this.parent_modid, modid));
            }
        });
    }

    public <T extends MobEntity, A extends EntityModel<T>> ReplaceDefinition<T> lambdaReplace(EntityType<T> type, float shadowSize, ImplRenderer.RenderDef<T, A> renderDef) {
        return new ReplaceDefinition<T>(type, renderDef.apply(ImplRenderer.factory(this.parent_modid, shadowSize)).done());
    }

    public static class ReplacementConfig {
        public OverridesConfiguration replace_config;

        public ReplacementConfig(ModelReplacementHandler parent, ForgeConfigSpec.Builder builder, BiConsumer<ForgeConfigSpec.Builder, Map<String, Map<String, ForgeConfigSpec.BooleanValue>>> manuals) {
            HashMap<String, Map<String, ForgeConfigSpec.BooleanValue>> map = new HashMap<String, Map<String, ForgeConfigSpec.BooleanValue>>();
            parent.replaceDefs.values().forEach(m -> m.keySet().forEach(pair -> ReplacementConfig.addConfig(builder, map, (String)pair.getLeft(), (String)pair.getRight())));
            manuals.accept(builder, map);
            this.replace_config = new OverridesConfiguration(map);
        }

        public static void addConfig(ForgeConfigSpec.Builder builder, Map<String, Map<String, ForgeConfigSpec.BooleanValue>> map, String modid, String name) {
            map.putIfAbsent(modid, new HashMap());
            builder.push(modid);
            ForgeConfigSpec.BooleanValue value = builder.define("replace_" + name, true);
            map.get(modid).put(name, value);
            builder.pop();
        }

        public static class OverridesConfiguration {
            public final Map<String, Map<String, ForgeConfigSpec.BooleanValue>> mods;

            public OverridesConfiguration(Map<String, Map<String, ForgeConfigSpec.BooleanValue>> mods) {
                this.mods = mods;
            }

            public Map<String, Map<String, ForgeConfigSpec.BooleanValue>> getModsMap() {
                return this.mods;
            }
        }
    }

    public static class ReplaceDefinition<T extends LivingEntity> {
        public final EntityType<T> type;
        public final IRenderFactory<T> factory;

        public ReplaceDefinition(EntityType<T> type, IRenderFactory<T> factory) {
            this.type = type;
            this.factory = factory;
        }
    }

    public static enum RegistrationTime {
        MODELREGISTRY,
        CLIENTSETUP;

    }
}

