/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.entity.util;

import dev.itsmeow.whisperwoods.imdlib.entity.util.IVariant;
import dev.itsmeow.whisperwoods.imdlib.entity.util.IVariantTypes;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public interface ISelectiveVariantTypes<T extends MobEntity>
extends IVariantTypes<T> {
    @Override
    @Nullable
    default public ILivingEntityData initData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        if (this.getContainer().biomeVariants && (reason == SpawnReason.CHUNK_GENERATION || reason == SpawnReason.NATURAL)) {
            Biome biome = world.func_226691_t_(this.getImplementation().func_180425_c());
            String[] validTypes = this.getTypesFor(biome, BiomeDictionary.getTypes((Biome)biome));
            String varStr = validTypes[this.getImplementation().func_70681_au().nextInt(validTypes.length)];
            IVariant variant = this.getContainer().getVariantForName(varStr);
            if (variant == null || !varStr.equals(variant.getName())) {
                throw new RuntimeException("Received invalid variant string from selective type: " + varStr + " on entity " + this.getContainer().entityName);
            }
            if (livingdata instanceof IVariantTypes.TypeData) {
                variant = ((IVariantTypes.TypeData)livingdata).typeData;
            } else {
                livingdata = new IVariantTypes.TypeData(variant);
            }
            this.setType(variant);
        } else {
            IVariant variant = this.getRandomType();
            if (livingdata instanceof IVariantTypes.TypeData) {
                variant = ((IVariantTypes.TypeData)livingdata).typeData;
            } else {
                livingdata = new IVariantTypes.TypeData(variant);
            }
            this.setType(variant);
        }
        return livingdata;
    }

    @Override
    @Nullable
    default public ILivingEntityData initAgeableData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        if (this.getContainer().biomeVariants && (reason == SpawnReason.CHUNK_GENERATION || reason == SpawnReason.NATURAL)) {
            Biome biome = world.func_226691_t_(this.getImplementation().func_180425_c());
            String[] validTypes = this.getTypesFor(biome, BiomeDictionary.getTypes((Biome)biome));
            String varStr = validTypes[this.getImplementation().func_70681_au().nextInt(validTypes.length)];
            IVariant variant = this.getContainer().getVariantForName(varStr);
            if (livingdata instanceof IVariantTypes.AgeableTypeData) {
                variant = ((IVariantTypes.AgeableTypeData)((Object)livingdata)).typeData;
            } else {
                livingdata = livingdata instanceof AgeableEntity.AgeableData ? new IVariantTypes.AgeableTypeData((AgeableEntity.AgeableData)livingdata, variant) : new IVariantTypes.AgeableTypeData(variant);
            }
            this.setType(variant);
        } else {
            IVariant variant = this.getRandomType();
            if (livingdata instanceof IVariantTypes.AgeableTypeData) {
                variant = ((IVariantTypes.AgeableTypeData)((Object)livingdata)).typeData;
            } else {
                livingdata = livingdata instanceof AgeableEntity.AgeableData ? new IVariantTypes.AgeableTypeData((AgeableEntity.AgeableData)livingdata, variant) : new IVariantTypes.AgeableTypeData(variant);
            }
            this.setType(variant);
        }
        return livingdata;
    }

    public String[] getTypesFor(Biome var1, Set<BiomeDictionary.Type> var2);
}

