/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.entity.util.builder;

import dev.itsmeow.whisperwoods.imdlib.entity.util.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.IVariant;
import dev.itsmeow.whisperwoods.imdlib.util.BiomeListBuilder;
import dev.itsmeow.whisperwoods.imdlib.util.HeadType;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.MobEntity;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;

public interface IEntityBuilder<T extends MobEntity, C extends EntityTypeContainer<T>, B extends IEntityBuilder<T, C, B>> {
    public B spawn(EntityClassification var1, int var2, int var3, int var4);

    public B egg(int var1, int var2);

    public B size(float var1, float var2);

    public B despawn();

    public B config(EntityTypeContainer.CustomConfigurationHolder var1);

    public B clientConfig(EntityTypeContainer.CustomConfigurationHolder var1);

    public B placement(EntitySpawnPlacementRegistry.PlacementType var1, Heightmap.Type var2, EntitySpawnPlacementRegistry.IPlacementPredicate<T> var3);

    public B defaultPlacement(EntitySpawnPlacementRegistry.IPlacementPredicate<T> var1);

    public B waterPlacement();

    public B waterPlacement(EntitySpawnPlacementRegistry.IPlacementPredicate<T> var1);

    public B biomes(BiomeDictionary.Type ... var1);

    public B biomes(Supplier<Biome[]> var1);

    public B biomes(Function<BiomeListBuilder, BiomeListBuilder> var1);

    public B variants(IVariant ... var1);

    public B variants(String ... var1);

    public B variants(int var1);

    public B variants(Function<String, IVariant> var1, String ... var2);

    public HeadType.Builder<T, C, B> head(String var1);

    public HeadType.Builder<T, C, B> head();

    public void setHeadBuild(Function<C, HeadType> var1);

    public String getMod();

    default public void preBuild() {
    }

    default public void postBuild(C container) {
    }

    public C rawBuild();

    default public C build() {
        this.preBuild();
        C container = this.rawBuild();
        this.postBuild(container);
        return container;
    }
}

