/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.item;

import dev.itsmeow.whisperwoods.imdlib.entity.util.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.whisperwoods.imdlib.item.IContainerItem;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemModEntityContainer<T extends MobEntity>
extends Item
implements IContainerItem<T> {
    protected final EntityTypeContainerContainable<T, ItemModEntityContainer<T>> typeContainer;
    protected IContainerItem.ITooltipFunction tooltip;

    public static final <T extends MobEntity> BiFunction<EntityTypeContainerContainable<T, ItemModEntityContainer<T>>, IContainerItem.ITooltipFunction, ItemModEntityContainer<T>> get(String name, ItemGroup group) {
        return (container, tooltip) -> new ItemModEntityContainer(container, String.format(name, container.entityName), (IContainerItem.ITooltipFunction)tooltip, group);
    }

    public ItemModEntityContainer(EntityTypeContainerContainable<T, ItemModEntityContainer<T>> typeContainer, String name, ItemGroup group) {
        this(typeContainer, name, IContainerItem.VARIANT_TOOLTIP, group);
    }

    public ItemModEntityContainer(EntityTypeContainerContainable<T, ItemModEntityContainer<T>> typeContainer, String name, IContainerItem.ITooltipFunction tooltip, ItemGroup group) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(group));
        this.setRegistryName(typeContainer.getModId(), name);
        this.typeContainer = typeContainer;
        this.tooltip = tooltip;
        this.addPropertyOverrides(this);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            ItemStack itemstack = playerIn.func_184586_b(handIn);
            RayTraceResult raytraceresult = ItemModEntityContainer.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
                return new ActionResult(ActionResultType.PASS, (Object)itemstack);
            }
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
                return new ActionResult(ActionResultType.PASS, (Object)itemstack);
            }
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceresult;
            BlockPos blockpos = blockraytraceresult.func_216350_a();
            this.placeEntity(worldIn, playerIn.func_184586_b(handIn), blockpos.func_177972_a(blockraytraceresult.func_216354_b()));
            if (!playerIn.func_184812_l_()) {
                playerIn.func_184201_a(handIn == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)this.typeContainer.getEmptyContainerItem()));
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (tooltip != null) {
            this.tooltip.addInformation(this.typeContainer, stack, worldIn, tooltip);
        }
    }

    @Override
    public EntityTypeContainer<T> getContainer() {
        return this.typeContainer;
    }
}

