/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.item;

import dev.itsmeow.whisperwoods.WhisperwoodsMod;
import dev.itsmeow.whisperwoods.client.renderer.tile.model.ModelHGSkullMask;
import dev.itsmeow.whisperwoods.item.ItemBlockModeledArmor;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class ItemBlockHirschgeistSkull
extends ItemBlockModeledArmor {
    public ItemBlockHirschgeistSkull(Block blockIn) {
        super(blockIn, HGArmorMaterial.get(), EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(WhisperwoodsMod.TAB));
        this.addToBlockToItemMap(Item.field_179220_a, (Item)this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected <A extends BipedModel<?>> A getBaseModelInstance() {
        return (A)((Object)ModelHGSkullMask.INSTANCE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected <A extends BipedModel<?>> A displays(A armorModel, EquipmentSlotType slot) {
        armorModel.field_78116_c.field_78806_j = true;
        armorModel.field_178720_f.field_78806_j = true;
        armorModel.field_78115_e.field_78806_j = false;
        armorModel.field_178723_h.field_78806_j = false;
        armorModel.field_178724_i.field_78806_j = false;
        armorModel.field_178721_j.field_78806_j = false;
        armorModel.field_178722_k.field_78806_j = false;
        return armorModel;
    }

    @Override
    @Nullable
    protected BlockState getStateForPlacement(BlockItemUseContext ctx) {
        BlockState returnedState = null;
        World world = ctx.func_195991_k();
        BlockPos clickPos = ctx.func_195995_a();
        for (Direction side : ctx.func_196009_e()) {
            BlockState newState = this.getBlock().func_196258_a(ctx);
            if (newState == null || !newState.func_196955_c((IWorldReader)world, clickPos)) continue;
            returnedState = newState;
            break;
        }
        return returnedState;
    }

    @Override
    public ActionResultType tryPlace(BlockItemUseContext ctx) {
        if (!ctx.func_196011_b()) {
            return ActionResultType.FAIL;
        }
        if (ctx.func_196000_l() == Direction.DOWN) {
            return ActionResultType.FAIL;
        }
        BlockState placementState = this.getStateForPlacement(ctx);
        if (placementState == null) {
            return ActionResultType.FAIL;
        }
        if (!this.placeBlock(ctx, placementState)) {
            return ActionResultType.FAIL;
        }
        BlockPos blockpos = ctx.func_195995_a();
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        BlockState newState = world.func_180495_p(blockpos);
        Block block = newState.func_177230_c();
        if (block == placementState.func_177230_c()) {
            this.onBlockPlaced(blockpos, world, player, stack, newState);
            block.func_180633_a(world, blockpos, newState, (LivingEntity)player, stack);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, blockpos, stack);
            }
        }
        SoundType soundtype = newState.getSoundType((IWorldReader)world, blockpos, (Entity)ctx.func_195999_j());
        world.func_184133_a(player, blockpos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        stack.func_190918_g(1);
        return ActionResultType.SUCCESS;
    }

    public static class HGArmorMaterial
    implements IArmorMaterial {
        private static HGArmorMaterial INSTANCE;
        private static final int[] MAX_DAMAGE_ARRAY;
        private static final int[] DAMAGE_REDUCTION_AMOUNT_ARRAY;

        public static final HGArmorMaterial get() {
            if (INSTANCE == null) {
                INSTANCE = new HGArmorMaterial();
            }
            return INSTANCE;
        }

        public int func_200896_a(EquipmentSlotType slotIn) {
            return MAX_DAMAGE_ARRAY[slotIn.func_188454_b()] * 15;
        }

        public int func_200902_b(EquipmentSlotType slotIn) {
            return DAMAGE_REDUCTION_AMOUNT_ARRAY[slotIn.func_188454_b()];
        }

        public int func_200900_a() {
            return 9;
        }

        public SoundEvent func_200899_b() {
            return SoundEvents.field_187719_p;
        }

        public Ingredient func_200898_c() {
            return Ingredient.func_199805_a((Tag)Tags.Items.BONES);
        }

        public String func_200897_d() {
            return "whisperwoods:hirschgeist";
        }

        public float func_200901_e() {
            return 0.0f;
        }

        static {
            MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
            DAMAGE_REDUCTION_AMOUNT_ARRAY = new int[]{2, 5, 6, 2};
        }
    }
}

