/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.network;

import dev.itsmeow.whisperwoods.particle.WispParticleData;
import dev.itsmeow.whisperwoods.util.WWClientTaskQueue;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class HOFEffectPacket {
    public HOFEffectType type;
    public Vector3f pos;
    public int color;

    public HOFEffectPacket(HOFEffectType type, Vector3f pos, int color) {
        this.type = type;
        this.pos = pos;
        this.color = color;
    }

    public static void encode(HOFEffectPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.type.ordinal());
        buf.writeFloat(pkt.pos.func_195899_a());
        buf.writeFloat(pkt.pos.func_195900_b());
        buf.writeFloat(pkt.pos.func_195902_c());
        buf.writeInt(pkt.color);
    }

    public static HOFEffectPacket decode(PacketBuffer buf) {
        int i = buf.readInt();
        if (i < 0 || i >= HOFEffectType.values().length) {
            return null;
        }
        return new HOFEffectPacket(HOFEffectType.values()[i], new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat()), buf.readInt());
    }

    public static void handle(HOFEffectPacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            if (Minecraft.func_71410_x().field_71441_e != null && msg != null) {
                HOFEffectType type = msg.type;
                Vector3f pos = msg.pos;
                int color = msg.color;
                float r = color >> 16 & 0xFF;
                float g = color >> 8 & 0xFF;
                float b = color & 0xFF;
                int amt = 90;
                float angle = 4.0f;
                float speed = 0.5f;
                WispParticleData data = new WispParticleData(r, g, b, 1.0f);
                for (int i = 0; i < 90; ++i) {
                    float pAngle = (float)Math.toRadians(4.0f * (float)i);
                    Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)data, (double)pos.func_195899_a(), (double)pos.func_195900_b(), (double)pos.func_195902_c(), 0.5 * Math.cos(pAngle), 0.0, 0.5 * Math.sin(pAngle));
                }
                if (type == HOFEffectType.HIRSCHGEIST) {
                    WWClientTaskQueue.schedule(21, () -> {
                        for (int i = 0; i < 90; ++i) {
                            float pAngle = (float)Math.toRadians(4.0f * (float)i);
                            Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)data, (double)pos.func_195899_a() + 8.0 * Math.cos(pAngle), (double)pos.func_195900_b(), (double)pos.func_195902_c() + 8.0 * Math.sin(pAngle), -0.5 * Math.cos(pAngle), 0.0, -0.5 * Math.sin(pAngle));
                        }
                        WWClientTaskQueue.schedule(25, () -> {
                            Minecraft.func_71410_x().field_71441_e.func_184134_a((double)pos.func_195899_a(), (double)pos.func_195900_b(), (double)pos.func_195902_c(), SoundEvents.field_219650_fj, SoundCategory.BLOCKS, 1.0f, 0.25f, false);
                            WispParticleData data2 = new WispParticleData(r, g, b, 0.25f);
                            for (int i = 0; i < 500; ++i) {
                                float xOff = (float)((Math.random() - 0.5) * 5.0);
                                float yOff = (float)(Math.random() * 2.5);
                                float zOff = (float)((Math.random() - 0.5) * 5.0);
                                Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)data2, (double)(pos.func_195899_a() + xOff), Math.floor(pos.func_195900_b()) - 1.0 + (double)yOff, (double)(pos.func_195902_c() + zOff), (double)(xOff / 16.0f), (double)(yOff / 16.0f), (double)(zOff / 16.0f));
                            }
                        });
                    });
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum HOFEffectType {
        CIRCLE,
        HIRSCHGEIST;

    }
}

