/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.util;

import dev.itsmeow.whisperwoods.init.ModBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraftforge.fml.RegistryObject;

public class WispColors {
    private static final List<WispColor> ARRAY = new ArrayList<WispColor>();
    private static final Map<Integer, WispColor> BY_COLOR = new HashMap<Integer, WispColor>();
    public static final WispColor BLUE = WispColors.r(new WispColor("BLUE", 61423, ModBlocks.GHOST_LIGHT_ELECTRIC_BLUE, ModBlocks.WISP_LANTERN_BLUE));
    public static final WispColor ORANGE = WispColors.r(new WispColor("ORANGE", 15894784, ModBlocks.GHOST_LIGHT_FIERY_ORANGE, ModBlocks.WISP_LANTERN_ORANGE));
    public static final WispColor YELLOW = WispColors.r(new WispColor("YELLOW", 16762396, ModBlocks.GHOST_LIGHT_GOLD, ModBlocks.WISP_LANTERN_YELLOW));
    public static final WispColor PURPLE = WispColors.r(new WispColor("PURPLE", 13248490, ModBlocks.GHOST_LIGHT_MAGIC_PURPLE, ModBlocks.WISP_LANTERN_PURPLE));
    public static final WispColor GREEN = WispColors.r(new WispColor("GREEN", 2883385, ModBlocks.GHOST_LIGHT_TOXIC_GREEN, ModBlocks.WISP_LANTERN_GREEN));

    private static WispColor r(WispColor c) {
        ARRAY.add(c);
        BY_COLOR.put(c.getColor(), c);
        return c;
    }

    @Nullable
    public static WispColor byColor(int color) {
        return BY_COLOR.get(color);
    }

    public static WispColor[] values() {
        return ARRAY.toArray(new WispColor[ARRAY.size()]);
    }

    public static final class WispColor {
        private final String name;
        private final int color;
        private final RegistryObject<Block> ghostLight;
        private final RegistryObject<Block> lantern;

        private WispColor(String name, int color, RegistryObject<Block> ghostLight, RegistryObject<Block> lantern) {
            this.name = name;
            this.color = color;
            this.ghostLight = ghostLight;
            this.lantern = lantern;
        }

        public RegistryObject<Block> getGhostLight() {
            return this.ghostLight;
        }

        public RegistryObject<Block> getLantern() {
            return this.lantern;
        }

        public String name() {
            return this.name;
        }

        public int ordinal() {
            return ARRAY.indexOf(this);
        }

        public int getColor() {
            return this.color;
        }

        public String toString() {
            return this.name + "/" + Integer.toHexString(this.color);
        }
    }
}

