/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import java.util.List;
import java.util.function.BiFunction;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.gui.GuiConfigHome;
import mcp.mobius.waila.overlay.TickHandler;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;

public abstract class WailaClient {
    public static class_304 openConfig;
    public static class_304 showOverlay;
    public static class_304 toggleLiquid;
    public static class_304 showRecipeInput;
    public static class_304 showRecipeOutput;
    protected static BiFunction<String, Integer, class_304> keyBindingBuilder;
    public static Runnable onShowRecipeInput;
    public static Runnable onShowRecipeOutput;

    protected static void init() {
        openConfig = keyBindingBuilder.apply("config", 320);
        showOverlay = keyBindingBuilder.apply("show_overlay", 321);
        toggleLiquid = keyBindingBuilder.apply("toggle_liquid", 322);
        showRecipeInput = keyBindingBuilder.apply("show_recipe_input", 323);
        showRecipeOutput = keyBindingBuilder.apply("show_recipe_output", 324);
    }

    protected static void onJoinServer() {
        if (!Waila.packet.isServerAvailable()) {
            Waila.LOGGER.warn("WTHIT is not found on the server, all syncable config will reset to their default value.");
            PluginConfig.INSTANCE.getSyncableConfigs().forEach(config -> config.setValue(config.getDefaultValue()));
        }
    }

    protected static void onClientTick() {
        class_310 client = class_310.method_1551();
        WailaConfig config = Waila.CONFIG.get();
        TickHandler.tickClient();
        while (openConfig.method_1436()) {
            client.method_1507((class_437)new GuiConfigHome(null));
        }
        while (showOverlay.method_1436()) {
            if (config.getGeneral().getDisplayMode() != WailaConfig.DisplayMode.TOGGLE) continue;
            config.getGeneral().setDisplayTooltip(!config.getGeneral().shouldDisplayTooltip());
        }
        while (toggleLiquid.method_1436()) {
            PluginConfig.INSTANCE.set(WailaConstants.CONFIG_SHOW_FLUID, !PluginConfig.INSTANCE.get(WailaConstants.CONFIG_SHOW_FLUID));
        }
        while (showRecipeInput.method_1436() && onShowRecipeInput != null) {
            onShowRecipeInput.run();
        }
        while (showRecipeOutput.method_1436() && onShowRecipeOutput != null) {
            onShowRecipeOutput.run();
        }
    }

    protected static void onItemTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (PluginConfig.INSTANCE.get(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            tooltip.add((class_2561)new class_2585(String.format(Waila.CONFIG.get().getFormatting().getModName(), ModIdentification.getModInfo(stack).getName())));
        }
    }
}

