/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl.config;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import mcp.mobius.waila.api.impl.config.HUDTheme;
import net.minecraft.class_2960;

public class WailaConfig {
    private int configVersion = 0;
    private final ConfigGeneral general = new ConfigGeneral();
    private final ConfigOverlay overlay = new ConfigOverlay();
    private final ConfigFormatting formatting = new ConfigFormatting();

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    public ConfigGeneral getGeneral() {
        return this.general;
    }

    public ConfigOverlay getOverlay() {
        return this.overlay;
    }

    public ConfigFormatting getFormatting() {
        return this.formatting;
    }

    public static class ConfigGeneral {
        private boolean displayTooltip = true;
        private boolean shiftForDetails = false;
        private DisplayMode displayMode = DisplayMode.TOGGLE;
        private boolean hideFromPlayerList = true;
        private boolean hideFromDebug = true;
        private boolean enableTextToSpeech = false;
        private int rateLimit = 250;
        private int maxHealthForRender = 40;
        private int maxHeartsPerLine = 10;

        public void setDisplayTooltip(boolean displayTooltip) {
            this.displayTooltip = displayTooltip;
        }

        public void setShiftForDetails(boolean shiftForDetails) {
            this.shiftForDetails = shiftForDetails;
        }

        public void setDisplayMode(DisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        public void setHideFromPlayerList(boolean hideFromPlayerList) {
            this.hideFromPlayerList = hideFromPlayerList;
        }

        public void setHideFromDebug(boolean hideFromDebug) {
            this.hideFromDebug = hideFromDebug;
        }

        public void setEnableTextToSpeech(boolean enableTextToSpeech) {
            this.enableTextToSpeech = enableTextToSpeech;
        }

        public void setRateLimit(int rateLimit) {
            this.rateLimit = rateLimit;
        }

        public void setMaxHealthForRender(int maxHealthForRender) {
            this.maxHealthForRender = maxHealthForRender;
        }

        public void setMaxHeartsPerLine(int maxHeartsPerLine) {
            this.maxHeartsPerLine = maxHeartsPerLine;
        }

        public boolean shouldDisplayTooltip() {
            return this.displayTooltip;
        }

        public boolean shouldShiftForDetails() {
            return this.shiftForDetails;
        }

        public DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        public boolean shouldHideFromPlayerList() {
            return this.hideFromPlayerList;
        }

        public boolean shouldHideFromDebug() {
            return this.hideFromDebug;
        }

        public boolean shouldEnableTextToSpeech() {
            return this.enableTextToSpeech;
        }

        public int getRateLimit() {
            this.rateLimit = Math.max(this.rateLimit, 250);
            return this.rateLimit;
        }

        public int getMaxHealthForRender() {
            return this.maxHealthForRender;
        }

        public int getMaxHeartsPerLine() {
            return this.maxHeartsPerLine;
        }
    }

    public static class ConfigOverlay {
        private final Position position = new Position();
        private float scale = 1.0f;
        private final ConfigOverlayColor color = new ConfigOverlayColor();

        public void setScale(float scale) {
            this.scale = scale;
        }

        public Position getPosition() {
            return this.position;
        }

        public float getScale() {
            return this.scale;
        }

        public ConfigOverlayColor getColor() {
            return this.color;
        }

        public static class Position {
            private int x = 0;
            private int y = 0;
            private HorizontalAlignment alignX = HorizontalAlignment.CENTER;
            private VerticalAlignment alignY = VerticalAlignment.TOP;
            private HorizontalAlignment anchorX = HorizontalAlignment.CENTER;
            private VerticalAlignment anchorY = VerticalAlignment.TOP;

            public void setX(int x) {
                this.x = x;
            }

            public void setY(int y) {
                this.y = y;
            }

            public void setAlignX(HorizontalAlignment alignX) {
                this.alignX = alignX;
            }

            public void setAlignY(VerticalAlignment alignY) {
                this.alignY = alignY;
            }

            public void setAnchorX(HorizontalAlignment anchorX) {
                this.anchorX = anchorX;
            }

            public void setAnchorY(VerticalAlignment anchorY) {
                this.anchorY = anchorY;
            }

            public int getX() {
                return this.x;
            }

            public int getY() {
                return this.y;
            }

            public HorizontalAlignment getAlignX() {
                return this.alignX;
            }

            public VerticalAlignment getAlignY() {
                return this.alignY;
            }

            public HorizontalAlignment getAnchorX() {
                return this.anchorX;
            }

            public VerticalAlignment getAnchorY() {
                return this.anchorY;
            }

            public static enum HorizontalAlignment {
                LEFT(0.0),
                CENTER(0.5),
                RIGHT(1.0);

                public final double multiplier;

                private HorizontalAlignment(double multiplier) {
                    this.multiplier = multiplier;
                }
            }

            public static enum VerticalAlignment {
                TOP(0.0),
                MIDDLE(0.5),
                BOTTOM(1.0);

                public final double multiplier;

                private VerticalAlignment(double multiplier) {
                    this.multiplier = multiplier;
                }
            }
        }

        public static class ConfigOverlayColor {
            private int alpha = 80;
            private Map<class_2960, HUDTheme> themes = Maps.newHashMap();
            private class_2960 activeTheme = HUDTheme.VANILLA.getId();

            public ConfigOverlayColor() {
                this.themes.put(HUDTheme.VANILLA.getId(), HUDTheme.VANILLA);
                this.themes.put(HUDTheme.DARK.getId(), HUDTheme.DARK);
            }

            public int getAlpha() {
                return this.alpha == 100 ? 255 : (this.alpha == 0 ? 0x1000000 : (int)((float)this.alpha / 100.0f * 256.0f) << 24);
            }

            public int getRawAlpha() {
                return this.alpha;
            }

            public HUDTheme getTheme() {
                return this.themes.getOrDefault(this.activeTheme, HUDTheme.VANILLA);
            }

            public Collection<HUDTheme> getThemes() {
                return this.themes.values();
            }

            public void setAlpha(int alpha) {
                this.alpha = alpha;
            }

            public int getBackgroundColor() {
                return this.getAlpha() + this.getTheme().getBackgroundColor();
            }

            public int getGradientStart() {
                return this.getAlpha() + this.getTheme().getGradientStart();
            }

            public int getGradientEnd() {
                return this.getAlpha() + this.getTheme().getGradientEnd();
            }

            public int getFontColor() {
                return this.getTheme().getFontColor();
            }

            public void applyTheme(class_2960 id) {
                this.activeTheme = this.themes.containsKey(id) ? id : this.activeTheme;
            }

            public static class Adapter
            implements JsonSerializer<ConfigOverlayColor>,
            JsonDeserializer<ConfigOverlayColor> {
                public ConfigOverlayColor deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    JsonObject json = element.getAsJsonObject();
                    ConfigOverlayColor color = new ConfigOverlayColor();
                    color.alpha = json.getAsJsonPrimitive("alpha").getAsInt();
                    color.activeTheme = new class_2960(json.getAsJsonPrimitive("activeTheme").getAsString());
                    color.themes = Maps.newHashMap();
                    json.getAsJsonArray("themes").forEach(e -> {
                        HUDTheme theme = (HUDTheme)context.deserialize(e, HUDTheme.class);
                        color.themes.put(theme.getId(), theme);
                    });
                    return color;
                }

                public JsonElement serialize(ConfigOverlayColor src, Type typeOfSrc, JsonSerializationContext context) {
                    JsonObject json = new JsonObject();
                    json.addProperty("alpha", (Number)src.alpha);
                    json.add("themes", context.serialize(src.themes.values()));
                    json.addProperty("activeTheme", src.activeTheme.toString());
                    return json;
                }
            }
        }
    }

    public static class ConfigFormatting {
        private String modName = "\u00a79\u00a7o%s";
        private String blockName = "\u00a7f%s";
        private String fluidName = "\u00a7f%s";
        private String entityName = "\u00a7f%s";
        private String registryName = "\u00a78%s";

        public void setModName(String modName) {
            this.modName = modName;
        }

        public void setBlockName(String blockName) {
            this.blockName = blockName;
        }

        public void setFluidName(String fluidName) {
            this.fluidName = fluidName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public String getModName() {
            return this.modName;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public String getFluidName() {
            return this.fluidName;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getRegistryName() {
            return this.registryName;
        }
    }

    public static enum DisplayMode {
        HOLD_KEY,
        TOGGLE;

    }
}

