/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.utils.ExceptionHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public final class DisplayUtil
extends class_332 {
    private static final DisplayUtil DH = new DisplayUtil();
    private static final String[] NUM_SUFFIXES = new String[]{"", "k", "m", "b", "t"};
    private static final int MAX_LENGTH = 4;
    private static final class_310 CLIENT = class_310.method_1551();
    private static final DecimalFormat SHORT_HAND = new DecimalFormat("##0E0");
    private static final class_2585 UNNAMED = new class_2585("Unnamed");

    public static void bind(class_2960 texture) {
        CLIENT.method_1531().method_22813(texture);
    }

    public static void renderStack(int x, int y, class_1799 stack) {
        DisplayUtil.renderStack(x, y, stack, stack.method_7947() > 1 ? DisplayUtil.shortHandNumber(stack.method_7947()) : "");
    }

    public static void renderStack(int x, int y, class_1799 stack, String countText) {
        DisplayUtil.enable3DRender();
        try {
            CLIENT.method_1480().method_27953(stack, x, y);
            CLIENT.method_1480().method_4022(DisplayUtil.CLIENT.field_1772, stack, x, y, countText);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            ExceptionHandler.handleErr(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    private static String shortHandNumber(Number number) {
        String shorthand = SHORT_HAND.format(number);
        shorthand = shorthand.replaceAll("E[0-9]", NUM_SUFFIXES[Character.getNumericValue(shorthand.charAt(shorthand.length() - 1)) / 3]);
        while (shorthand.length() > 4 || shorthand.matches("[0-9]+\\.[a-z]")) {
            shorthand = shorthand.substring(0, shorthand.length() - 2) + shorthand.substring(shorthand.length() - 1);
        }
        return shorthand;
    }

    public static void enable3DRender() {
        class_308.method_22890();
        RenderSystem.enableDepthTest();
    }

    public static void enable2DRender() {
        class_308.method_1450();
        RenderSystem.disableDepthTest();
    }

    public static void drawGradientRect(class_4587 matrices, int x, int y, int w, int h, int startColor, int endColor) {
        DH.method_25296(matrices, x, y, x + w, y + h, startColor, endColor);
    }

    public static void drawTexturedModalRect(class_4587 matrices, int x, int y, int textureX, int textureY, int width, int height, int tw, int th) {
        DisplayUtil.method_25293((class_4587)matrices, (int)x, (int)y, (int)width, (int)height, (float)textureX, (float)textureY, (int)tw, (int)th, (int)256, (int)256);
    }

    public static List<class_2561> itemDisplayNameMultiline(class_1799 itemstack) {
        ArrayList<class_2561> namelist = null;
        try {
            namelist = itemstack.method_7950((class_1657)DisplayUtil.CLIENT.field_1724, (class_1836)class_1836.class_1837.field_8934);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<class_2561>();
        }
        if (namelist.isEmpty()) {
            namelist.add((class_2561)UNNAMED);
        }
        namelist.set(0, (class_2561)new class_2585(itemstack.method_7932().field_8908.toString() + namelist.get(0)));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, (class_2561)namelist.get(i));
        }
        return namelist;
    }

    public static String itemDisplayNameShort(class_1799 itemstack) {
        List<class_2561> list = DisplayUtil.itemDisplayNameMultiline(itemstack);
        return String.format(Waila.CONFIG.get().getFormatting().getBlockName(), list.get(0).getString());
    }

    public static void renderIcon(class_4587 matrices, int x, int y, int sx, int sy, IconUI icon) {
        RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DisplayUtil.bind(field_22737);
        if (icon == null) {
            return;
        }
        RenderSystem.enableBlend();
        if (icon.bu != -1) {
            DisplayUtil.drawTexturedModalRect(matrices, x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayUtil.drawTexturedModalRect(matrices, x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
        RenderSystem.disableBlend();
    }
}

