/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.mixin.AccessorBossBarHud;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.DrawableText;
import mcp.mobius.waila.utils.TaggableList;
import mcp.mobius.waila.utils.TaggedText;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3528;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class Tooltip {
    public static Consumer<List<class_2561>> onCreate;
    public static Function<Rectangle, Rectangle> onPreRender;
    public static Consumer<Rectangle> onPostRender;
    static boolean shouldRender;
    private static final TaggableList<class_2960, class_2561> LINES;
    private static final Object2IntOpenHashMap<class_2561> LINE_HEIGHT;
    private static final class_3528<Rectangle> RENDER_RECT;
    private static final class_3528<Rectangle> RECT;
    private static class_1799 stack;
    private static int topOffset;
    private static boolean started;

    public static void start() {
        LINES.clear();
        LINE_HEIGHT.clear();
        stack = class_1799.field_8037;
        topOffset = 0;
        started = true;
    }

    public static void addLines(List<class_2561> lines) {
        Preconditions.checkState((boolean)started);
        lines.forEach(text -> {
            if (text instanceof TaggedText) {
                class_2960 tag = ((TaggedText)((Object)text)).getTag();
                LINES.setTag(tag, (class_2561)((TaggableList)lines).getTag(tag));
            } else {
                LINES.add(text);
            }
        });
    }

    public static void addLine(class_2561 line) {
        LINES.add(line);
    }

    public static void setStack(class_1799 stack) {
        Preconditions.checkState((boolean)started);
        Tooltip.stack = PluginConfig.INSTANCE.get(WailaConstants.CONFIG_SHOW_ITEM) ? stack : class_1799.field_8037;
    }

    public static void finish() {
        Preconditions.checkState((boolean)started);
        onCreate.accept(LINES);
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        float scale = Waila.CONFIG.get().getOverlay().getScale();
        WailaConfig.ConfigOverlay.Position pos = Waila.CONFIG.get().getOverlay().getPosition();
        int w = 0;
        int h = 0;
        for (class_2561 line : LINES) {
            int lineH;
            int lineW;
            if (line instanceof DrawableText) {
                Dimension size = ((DrawableText)line).getSize();
                lineW = size.width;
                lineH = size.height;
            } else {
                class_2561 text = line instanceof TaggedText ? LINES.getTag(((TaggedText)line).getTag()) : line;
                class_327 textRenderer = class_310.method_1551().field_1772;
                lineW = textRenderer.method_27525((class_5348)text);
                Objects.requireNonNull(textRenderer);
                lineH = 9 + 1;
            }
            w = Math.max(w, lineW);
            h += lineH;
            LINE_HEIGHT.put((Object)line, lineH);
        }
        topOffset = 0;
        if (!stack.method_7960()) {
            if (h < 16) {
                topOffset = (16 - h) / 2;
            }
            w = Math.max(w, 16) + 20;
            h = Math.max(h, 16);
        }
        w += 10;
        h += 8;
        int windowW = (int)((float)window.method_4486() / scale);
        int windowH = (int)((float)window.method_4502() / scale);
        WailaConfig.ConfigOverlay.Position.HorizontalAlignment anchorX = pos.getAnchorX();
        WailaConfig.ConfigOverlay.Position.VerticalAlignment anchorY = pos.getAnchorY();
        WailaConfig.ConfigOverlay.Position.HorizontalAlignment alignX = pos.getAlignX();
        WailaConfig.ConfigOverlay.Position.VerticalAlignment alignY = pos.getAlignY();
        double x = (double)windowW * anchorX.multiplier - (double)w * alignX.multiplier + (double)pos.getX();
        double y = (double)windowH * anchorY.multiplier - (double)h * alignY.multiplier + (double)pos.getY();
        if (anchorX == WailaConfig.ConfigOverlay.Position.HorizontalAlignment.CENTER && anchorY == WailaConfig.ConfigOverlay.Position.VerticalAlignment.TOP) {
            y += (double)(((AccessorBossBarHud)client.field_1705.method_1740()).getBossBars().size() * 19);
        }
        ((Rectangle)RECT.method_15332()).setRect(x, y, w, h);
        started = false;
    }

    public static void render(class_4587 matrices, float delta) {
        if (!shouldRender) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_3695 profiler = client.method_16011();
        WailaConfig config = Waila.CONFIG.get();
        profiler.method_15396("Waila Overlay");
        RenderSystem.pushMatrix();
        float scale = config.getOverlay().getScale();
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        DisplayUtil.enable2DRender();
        Rectangle rect = (Rectangle)RENDER_RECT.method_15332();
        rect.setRect((Rectangle2D)RECT.method_15332());
        rect = onPreRender.apply(rect);
        if (rect == null) {
            RenderSystem.enableDepthTest();
            RenderSystem.popMatrix();
            profiler.method_15407();
            return;
        }
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        WailaConfig.ConfigOverlay.ConfigOverlayColor color = config.getOverlay().getColor();
        int bg = color.getBackgroundColor();
        int gradStart = color.getGradientStart();
        int gradEnd = color.getGradientEnd();
        DisplayUtil.drawGradientRect(matrices, x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + w, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + w - 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, 1, gradStart, gradStart);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h - 1, w - 1, 1, gradEnd, gradEnd);
        if (!stack.method_7960()) {
            DisplayUtil.renderStack(x + 5, y + h / 2 - 8, stack, "");
            x += 20;
        }
        x += 6;
        y += 6 + topOffset;
        RenderSystem.enableBlend();
        for (class_2561 line : LINES) {
            if (line instanceof DrawableText) {
                ((DrawableText)line).render(matrices, x, y, delta);
            } else {
                class_327 textRenderer = client.field_1772;
                class_2561 text = line instanceof TaggedText ? LINES.getTag(((TaggedText)line).getTag()) : line;
                textRenderer.method_30881(matrices, text, (float)x, (float)y, color.getFontColor());
            }
            y += LINE_HEIGHT.getInt((Object)line);
        }
        RenderSystem.disableBlend();
        onPostRender.accept(rect);
        RenderSystem.enableDepthTest();
        RenderSystem.popMatrix();
        profiler.method_15407();
    }

    static {
        shouldRender = false;
        LINES = new TaggableList<class_2960, class_2561>(TaggedText::new);
        LINE_HEIGHT = new Object2IntOpenHashMap();
        RENDER_RECT = new class_3528(Rectangle::new);
        RECT = new class_3528(Rectangle::new);
        stack = class_1799.field_8037;
        topOffset = 0;
        started = false;
    }
}

