/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IDrawableText;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.plugin.core.WailaCore;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public enum EntityComponent implements IEntityComponentProvider
{
    INSTANCE;


    @Override
    public void appendHead(List<class_2561> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        class_1297 entity = accessor.getEntity();
        ((ITaggableList)tooltip).setTag(WailaConstants.OBJECT_NAME_TAG, new class_2585(String.format(accessor.getEntityNameFormat(), entity.method_5476().getString())));
        if (config.get(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            ((ITaggableList)tooltip).setTag(WailaConstants.REGISTRY_NAME_TAG, new class_2585(String.format(accessor.getRegistryNameFormat(), class_2378.field_11145.method_10221((Object)entity.method_5864()))));
        }
    }

    @Override
    public void appendBody(List<class_2561> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.get(WailaCore.CONFIG_SHOW_ENTITY_HEALTH) && accessor.getEntity() instanceof class_1309) {
            class_1309 living = (class_1309)accessor.getEntity();
            float health = living.method_6032();
            float maxHealth = living.method_6063();
            if (living.method_6063() > (float)Waila.CONFIG.get().getGeneral().getMaxHealthForRender()) {
                tooltip.add((class_2561)new class_2588("tooltip.waila.health", new Object[]{String.format("%.2f", Float.valueOf(health)), String.format("%.2f", Float.valueOf(maxHealth))}));
            } else {
                class_2487 healthData = new class_2487();
                healthData.method_10548("health", health / 2.0f);
                healthData.method_10548("max", maxHealth / 2.0f);
                tooltip.add((class_2561)IDrawableText.of(WailaCore.RENDER_ENTITY_HEALTH, healthData));
            }
        }
    }

    @Override
    public void appendTail(List<class_2561> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.get(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            ((ITaggableList)tooltip).setTag(WailaConstants.MOD_NAME_TAG, new class_2585(String.format(Waila.CONFIG.get().getFormatting().getModName(), ModIdentification.getModInfo(accessor.getEntity()).getName())));
        }
    }
}

