/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.forge;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaPlugins;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraftforge.fml.ModList;

public class ForgeWailaPlugins
extends WailaPlugins {
    static final String WAILA_PLUGIN = WailaPlugin.class.getName();

    @Override
    public void gatherPlugins() {
        ModList.get().getModFiles().forEach(modFile -> modFile.getConfigList(new String[]{"wailaPlugins"}).forEach(map -> {
            String id = (String)map.getConfigElement(new String[]{"id"}).get();
            String initializer = (String)map.getConfigElement(new String[]{"initializer"}).get();
            boolean[] satisfied = new boolean[]{true};
            map.getConfigElement(new String[]{"required"}).ifPresent(required -> {
                if (required instanceof String) {
                    satisfied[0] = ModList.get().isLoaded((String)required);
                } else if (required instanceof List) {
                    for (String s : (List)required) {
                        satisfied[0] = satisfied[0] & ModList.get().isLoaded(s);
                    }
                }
            });
            if (satisfied[0]) {
                ForgeWailaPlugins.createPlugin(id, initializer);
            }
        }));
        ModList.get().getAllScanData().forEach(data -> data.getAnnotations().forEach(annotation -> {
            String required;
            if (annotation.getAnnotationType().getClassName().equals(WAILA_PLUGIN) && ((required = annotation.getAnnotationData().getOrDefault("value", "")).isEmpty() || ModList.get().isLoaded(required))) {
                Waila.LOGGER.warn("Waila plugin {} is defined by deprecated method", (Object)annotation.getMemberName());
                ForgeWailaPlugins.createPlugin("legacy:" + annotation.getMemberName(), annotation.getMemberName());
            }
        }));
    }
}

