/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.utils.ExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public final class DisplayUtil
extends AbstractGui {
    private static final DisplayUtil DH = new DisplayUtil();
    private static final String[] NUM_SUFFIXES = new String[]{"", "k", "m", "b", "t"};
    private static final int MAX_LENGTH = 4;
    private static final Minecraft CLIENT = Minecraft.func_71410_x();
    private static final DecimalFormat SHORT_HAND = new DecimalFormat("##0E0");
    private static final StringTextComponent UNNAMED = new StringTextComponent("Unnamed");

    public static void bind(ResourceLocation texture) {
        CLIENT.func_110434_K().func_110577_a(texture);
    }

    public static void renderStack(int x, int y, ItemStack stack) {
        DisplayUtil.renderStack(x, y, stack, stack.func_190916_E() > 1 ? DisplayUtil.shortHandNumber(stack.func_190916_E()) : "");
    }

    public static void renderStack(int x, int y, ItemStack stack, String countText) {
        DisplayUtil.enable3DRender();
        try {
            CLIENT.func_175599_af().func_239390_c_(stack, x, y);
            CLIENT.func_175599_af().func_180453_a(DisplayUtil.CLIENT.field_71466_p, stack, x, y, countText);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            ExceptionHandler.handleErr(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    private static String shortHandNumber(Number number) {
        String shorthand = SHORT_HAND.format(number);
        shorthand = shorthand.replaceAll("E[0-9]", NUM_SUFFIXES[Character.getNumericValue(shorthand.charAt(shorthand.length() - 1)) / 3]);
        while (shorthand.length() > 4 || shorthand.matches("[0-9]+\\.[a-z]")) {
            shorthand = shorthand.substring(0, shorthand.length() - 2) + shorthand.substring(shorthand.length() - 1);
        }
        return shorthand;
    }

    public static void enable3DRender() {
        RenderHelper.func_227780_a_();
        RenderSystem.enableDepthTest();
    }

    public static void enable2DRender() {
        RenderHelper.func_74518_a();
        RenderSystem.disableDepthTest();
    }

    public static void drawGradientRect(MatrixStack matrices, int x, int y, int w, int h, int startColor, int endColor) {
        DH.func_238468_a_(matrices, x, y, x + w, y + h, startColor, endColor);
    }

    public static void drawTexturedModalRect(MatrixStack matrices, int x, int y, int textureX, int textureY, int width, int height, int tw, int th) {
        DisplayUtil.func_238466_a_((MatrixStack)matrices, (int)x, (int)y, (int)width, (int)height, (float)textureX, (float)textureY, (int)tw, (int)th, (int)256, (int)256);
    }

    public static List<ITextComponent> itemDisplayNameMultiline(ItemStack itemstack) {
        ArrayList<ITextComponent> namelist = null;
        try {
            namelist = itemstack.func_82840_a((PlayerEntity)DisplayUtil.CLIENT.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<ITextComponent>();
        }
        if (namelist.isEmpty()) {
            namelist.add((ITextComponent)UNNAMED);
        }
        namelist.set(0, (ITextComponent)new StringTextComponent(itemstack.func_77953_t().field_77937_e.toString() + namelist.get(0)));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, (ITextComponent)namelist.get(i));
        }
        return namelist;
    }

    public static String itemDisplayNameShort(ItemStack itemstack) {
        List<ITextComponent> list = DisplayUtil.itemDisplayNameMultiline(itemstack);
        return String.format(Waila.CONFIG.get().getFormatting().getBlockName(), list.get(0).getString());
    }

    public static void renderIcon(MatrixStack matrices, int x, int y, int sx, int sy, IconUI icon) {
        RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DisplayUtil.bind(field_230665_h_);
        if (icon == null) {
            return;
        }
        RenderSystem.enableBlend();
        if (icon.bu != -1) {
            DisplayUtil.drawTexturedModalRect(matrices, x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayUtil.drawTexturedModalRect(matrices, x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
        RenderSystem.disableBlend();
    }
}

