/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TooltipRegistry<T> {
    private final Map<Class<?>, Set<Entry<T>>> map = new Object2ObjectOpenHashMap();
    private final Map<Class<?>, List<T>> cache = new Object2ObjectOpenHashMap();
    private final List<Entry<?>> sorter = new ObjectArrayList();

    public void add(Class<?> key, T value, int priority) {
        this.map.computeIfAbsent(key, k -> new ObjectOpenHashSet()).add(new Entry<T>(value, priority));
    }

    public List<T> get(Object obj) {
        if (obj == null) {
            return ObjectLists.emptyList();
        }
        Class<?> clazz = obj.getClass();
        if (clazz == Object.class) {
            return ObjectLists.emptyList();
        }
        if (this.cache.containsKey(clazz)) {
            return this.cache.get(clazz);
        }
        this.sorter.clear();
        this.map.forEach((k, v) -> {
            if (k.isInstance(obj)) {
                this.sorter.addAll((Collection<Entry<?>>)v);
            }
        });
        this.sorter.sort(Comparator.comparingInt(e -> e.priority));
        ObjectArrayList list = new ObjectArrayList();
        for (Entry<?> entry : this.sorter) {
            list.add(entry.value);
        }
        if (list.isEmpty()) {
            list = ObjectLists.emptyList();
        }
        this.cache.put(clazz, (List<T>)list);
        return list;
    }

    public Map<Class<?>, Set<Entry<T>>> getMap() {
        return this.map;
    }

    public static class Entry<T> {
        public final int priority;
        public final T value;

        Entry(T value, int priority) {
            this.value = value;
            this.priority = priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return Objects.equals(this.value, entry.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

