/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core;

import com.google.common.base.Strings;
import java.util.List;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.plugin.core.WailaCore;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.INameable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public enum BlockComponent implements IBlockComponentProvider,
IServerDataProvider<TileEntity>
{
    INSTANCE;


    @Override
    public void appendHead(List<ITextComponent> tooltip, IBlockAccessor accessor, IPluginConfig config) {
        String name;
        if (accessor.getBlockState().func_185904_a().func_76224_d()) {
            return;
        }
        Block block = accessor.getBlock();
        String string = name = accessor.getBlockEntity() != null ? accessor.getServerData().func_74779_i("customName") : "";
        if (name.isEmpty()) {
            name = block.func_235333_g_().getString();
        }
        ((ITaggableList)tooltip).setTag(WailaConstants.OBJECT_NAME_TAG, new StringTextComponent(String.format(accessor.getBlockNameFormat(), name)));
        if (config.get(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            ((ITaggableList)tooltip).setTag(WailaConstants.REGISTRY_NAME_TAG, new StringTextComponent(String.format(accessor.getRegistryNameFormat(), Registry.field_212618_g.func_177774_c((Object)block))));
        }
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.get(WailaCore.CONFIG_SHOW_POS)) {
            BlockPos pos = accessor.getPosition();
            tooltip.add((ITextComponent)new StringTextComponent("(" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")"));
        }
        if (config.get(WailaCore.CONFIG_SHOW_STATES)) {
            BlockState state = accessor.getBlockState();
            state.func_235904_r_().forEach(p -> {
                Comparable value = state.func_177229_b(p);
                IFormattableTextComponent valueText = new StringTextComponent(value.toString()).func_230530_a_(Style.field_240709_b_.func_240712_a_(p instanceof BooleanProperty ? (value == Boolean.TRUE ? TextFormatting.GREEN : TextFormatting.RED) : TextFormatting.RESET));
                tooltip.add((ITextComponent)new StringTextComponent(p.func_177701_a() + ":").func_230529_a_((ITextComponent)valueText));
            });
        }
    }

    @Override
    public void appendTail(List<ITextComponent> tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (!config.get(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            return;
        }
        String modName = ModIdentification.getModInfo(accessor.getStack().func_77973_b()).getName();
        if (!Strings.isNullOrEmpty((String)modName)) {
            modName = String.format(accessor.getModNameFormat(), modName);
            ((ITaggableList)tooltip).setTag(WailaConstants.MOD_NAME_TAG, new StringTextComponent(modName));
        }
    }

    @Override
    public void appendServerData(CompoundNBT data, ServerPlayerEntity player, World world, TileEntity blockEntity) {
        ITextComponent name;
        if (blockEntity instanceof INameable && (name = ((INameable)blockEntity).func_200201_e()) != null) {
            data.func_74778_a("customName", name.getString());
        }
    }
}

