/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla;

import java.util.List;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.plugin.vanilla.WailaVanilla;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum PlantComponent implements IBlockComponentProvider
{
    INSTANCE;

    static final ItemStack WHEAT_STACK;
    static final ItemStack BEETROOT_STACK;

    @Override
    public ItemStack getDisplayItem(IBlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() == Blocks.field_150464_aj) {
            return WHEAT_STACK;
        }
        if (accessor.getBlock() == Blocks.field_185773_cZ) {
            return BEETROOT_STACK;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.get(WailaVanilla.CONFIG_CROP_PROGRESS)) {
            if (accessor.getBlock() instanceof CropsBlock) {
                CropsBlock crop = (CropsBlock)accessor.getBlock();
                PlantComponent.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().func_177229_b((Property)crop.func_185524_e())).intValue() / (float)crop.func_185526_g());
            } else if (accessor.getBlock() == Blocks.field_150394_bc || accessor.getBlock() == Blocks.field_150393_bb) {
                PlantComponent.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().func_177229_b((Property)BlockStateProperties.field_208170_W)).intValue() / 7.0f);
            } else if (accessor.getBlock() == Blocks.field_150375_by) {
                PlantComponent.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().func_177229_b((Property)BlockStateProperties.field_208167_T)).intValue() / 2.0f);
            } else if (accessor.getBlock() == Blocks.field_222434_lW) {
                PlantComponent.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().func_177229_b((Property)BlockStateProperties.field_208168_U)).intValue() / 3.0f);
            } else if (accessor.getBlock() == Blocks.field_150388_bm) {
                PlantComponent.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().func_177229_b((Property)BlockStateProperties.field_208168_U)).intValue() / 3.0f);
            }
        }
    }

    private static void addMaturityTooltip(List<ITextComponent> tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.crop_growth", new Object[]{String.format("%.0f%%", Float.valueOf(growthValue))}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.crop_growth", new Object[]{new TranslationTextComponent("tooltip.waila.crop_mature")}));
        }
    }

    static {
        WHEAT_STACK = new ItemStack((IItemProvider)Items.field_151015_O);
        BEETROOT_STACK = new ItemStack((IItemProvider)Items.field_185164_cV);
    }
}

