/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.hud;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.text2speech.Narrator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.function.Supplier;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.data.DataAccessor;
import mcp.mobius.waila.event.EventCanceller;
import mcp.mobius.waila.hud.Tooltip;
import mcp.mobius.waila.hud.component.DrawableComponent;
import mcp.mobius.waila.hud.component.PairComponent;
import mcp.mobius.waila.hud.component.TaggedComponent;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class TooltipHandler {
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final Object2IntOpenHashMap<class_2561> LINE_HEIGHT = new Object2IntOpenHashMap();
    private static final Supplier<Rectangle> RENDER_RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Rectangle> RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Narrator> NARRATOR = Suppliers.memoize(Narrator::getNarrator);
    private static final String COLON = ": ";
    static boolean shouldRender = false;
    private static String lastNarration = "";
    private static class_1799 stack = class_1799.field_8037;
    private static int topOffset;
    private static int colonOffset;
    private static int colonWidth;
    private static boolean started;

    public static void beginBuild() {
        TOOLTIP.clear();
        LINE_HEIGHT.clear();
        stack = class_1799.field_8037;
        topOffset = 0;
        colonOffset = 0;
        colonWidth = class_310.method_1551().field_1772.method_1727(COLON);
        started = true;
    }

    public static void add(Tooltip tooltip) {
        Preconditions.checkState((boolean)started);
        for (class_2561 component : tooltip) {
            class_2561 class_25612 = component;
            if (class_25612 instanceof TaggedComponent) {
                TaggedComponent tagged = (TaggedComponent)class_25612;
                TOOLTIP.set(tagged.tag, tagged.value);
                continue;
            }
            TooltipHandler.add(component);
        }
    }

    public static void add(class_2561 line) {
        Preconditions.checkState((boolean)started);
        TOOLTIP.add(line);
        class_2561 class_25612 = line;
        if (class_25612 instanceof PairComponent) {
            PairComponent pair = (PairComponent)class_25612;
            colonOffset = Math.max(colonOffset, class_310.method_1551().field_1772.method_27525((class_5348)pair.key));
        }
    }

    public static class_1799 getStack() {
        return stack;
    }

    public static void setStack(class_1799 stack) {
        Preconditions.checkState((boolean)started);
        TooltipHandler.stack = PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_ITEM) ? stack : class_1799.field_8037;
    }

    public static void endBuild() {
        Preconditions.checkState((boolean)started);
        for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
            listener.onHandleTooltip(TOOLTIP, DataAccessor.INSTANCE, PluginConfig.INSTANCE);
        }
        TooltipHandler.narrateObjectName();
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        float scale = Waila.config.get().getOverlay().getScale();
        WailaConfig.Overlay.Position pos = Waila.config.get().getOverlay().getPosition();
        int w = 0;
        int h = 0;
        for (class_2561 line : TOOLTIP) {
            int lineH;
            int lineW;
            if (line instanceof DrawableComponent) {
                Dimension size = ((DrawableComponent)line).getSize();
                lineW = size.width;
                lineH = size.height;
            } else {
                class_2561 class_25612 = line;
                if (class_25612 instanceof PairComponent) {
                    PairComponent pair = (PairComponent)class_25612;
                    lineW = colonOffset + colonWidth + client.field_1772.method_27525((class_5348)pair.value);
                } else {
                    class_2561 class_25613;
                    class_2561 class_25614 = line;
                    if (class_25614 instanceof TaggedComponent) {
                        TaggedComponent tagged = (TaggedComponent)class_25614;
                        class_25613 = tagged.value;
                    } else {
                        class_25613 = line;
                    }
                    class_2561 value = class_25613;
                    lineW = client.field_1772.method_27525((class_5348)value);
                }
                Objects.requireNonNull(client.field_1772);
                lineH = 9 + 1;
            }
            w = Math.max(w, lineW);
            h += lineH;
            LINE_HEIGHT.put((Object)line, lineH);
        }
        topOffset = 0;
        if (!stack.method_7960()) {
            if (h < 16) {
                topOffset = (16 - h) / 2;
            }
            w = Math.max(w, 16) + 20;
            h = Math.max(h, 16);
        }
        w += 10;
        h += 8;
        int windowW = (int)((float)window.method_4486() / scale);
        int windowH = (int)((float)window.method_4502() / scale);
        IWailaConfig.Overlay.Position.Align.X anchorX = pos.getAnchor().getX();
        IWailaConfig.Overlay.Position.Align.Y anchorY = pos.getAnchor().getY();
        IWailaConfig.Overlay.Position.Align.X alignX = pos.getAlign().getX();
        IWailaConfig.Overlay.Position.Align.Y alignY = pos.getAlign().getY();
        double x = (double)windowW * anchorX.multiplier - (double)w * alignX.multiplier + (double)pos.getX();
        double y = (double)windowH * anchorY.multiplier - (double)h * alignY.multiplier + (double)pos.getY();
        if (!pos.isBossBarsOverlap() && anchorX == IWailaConfig.Overlay.Position.Align.X.CENTER && anchorY == IWailaConfig.Overlay.Position.Align.Y.TOP) {
            y += (double)Math.min(client.field_1705.method_1740().field_2060.size() * 19, window.method_4502() / 3 + 2);
        }
        RECT.get().setRect(x, y, w, h);
        started = false;
    }

    public static void render(class_4587 matrices, float delta) {
        if (!shouldRender) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_3695 profiler = client.method_16011();
        WailaConfig config = Waila.config.get();
        profiler.method_15396("Waila Overlay");
        float scale = config.getOverlay().getScale();
        RenderSystem.getModelViewStack().method_22903();
        RenderSystem.getModelViewStack().method_22905(scale, scale, 1.0f);
        RenderSystem.applyModelViewMatrix();
        matrices.method_22903();
        DisplayUtil.enable2DRender();
        Rectangle rect = RENDER_RECT.get();
        rect.setRect(RECT.get());
        EventCanceller canceller = EventCanceller.INSTANCE;
        canceller.setCanceled(false);
        for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
            listener.onBeforeTooltipRender(matrices, rect, DataAccessor.INSTANCE, PluginConfig.INSTANCE, canceller);
            if (!canceller.isCanceled()) continue;
            matrices.method_22909();
            RenderSystem.enableDepthTest();
            RenderSystem.getModelViewStack().method_22909();
            RenderSystem.applyModelViewMatrix();
            profiler.method_15407();
            return;
        }
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        WailaConfig.Overlay.Color color = config.getOverlay().getColor();
        int bg = color.getBackgroundColor();
        int gradStart = color.getGradientStart();
        int gradEnd = color.getGradientEnd();
        DisplayUtil.drawGradientRect(matrices, x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + w, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + w - 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, 1, gradStart, gradStart);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h - 1, w - 1, 1, gradEnd, gradEnd);
        RenderSystem.enableBlend();
        int textX = x + (stack.method_7960() ? 6 : 26);
        int textY = y + 6 + topOffset;
        int fontColor = color.getFontColor();
        for (class_2561 line : TOOLTIP) {
            class_2561 class_25612 = line;
            if (class_25612 instanceof DrawableComponent) {
                DrawableComponent drawable = (DrawableComponent)class_25612;
                drawable.render(matrices, textX, textY, delta);
            } else {
                class_25612 = line;
                if (class_25612 instanceof PairComponent) {
                    PairComponent pair = (PairComponent)class_25612;
                    client.field_1772.method_30881(matrices, pair.key, (float)textX, (float)textY, fontColor);
                    client.field_1772.method_1720(matrices, COLON, (float)(textX + colonOffset), (float)textY, fontColor);
                    client.field_1772.method_30881(matrices, pair.value, (float)(textX + colonOffset + colonWidth), (float)textY, fontColor);
                } else {
                    class_2561 class_25613;
                    class_2561 class_25614 = line;
                    if (class_25614 instanceof TaggedComponent) {
                        TaggedComponent tagged = (TaggedComponent)class_25614;
                        class_25613 = tagged.value;
                    } else {
                        class_25613 = line;
                    }
                    class_2561 value = class_25613;
                    client.field_1772.method_30881(matrices, value, (float)textX, (float)textY, color.getFontColor());
                }
            }
            textY += LINE_HEIGHT.getInt((Object)line);
        }
        RenderSystem.disableBlend();
        matrices.method_22909();
        for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
            listener.onAfterTooltipRender(matrices, rect, DataAccessor.INSTANCE, PluginConfig.INSTANCE);
        }
        if (!stack.method_7960()) {
            DisplayUtil.renderStack(x + 5, y + h / 2 - 8, stack, "");
        }
        RenderSystem.enableDepthTest();
        RenderSystem.getModelViewStack().method_22909();
        RenderSystem.applyModelViewMatrix();
        profiler.method_15407();
    }

    private static void narrateObjectName() {
        String narrate;
        if (!shouldRender) {
            return;
        }
        Narrator narrator = NARRATOR.get();
        if (narrator.active() || !Waila.config.get().getGeneral().isEnableTextToSpeech() || class_310.method_1551().field_1755 instanceof class_408) {
            return;
        }
        class_2561 objectName = TOOLTIP.getTag(WailaConstants.OBJECT_NAME_TAG);
        if (objectName != null && !lastNarration.equalsIgnoreCase(narrate = objectName.getString())) {
            narrator.clear();
            narrator.say(narrate, true);
            lastNarration = narrate;
        }
    }

    static {
        started = false;
    }
}

