/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.component;

import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.plugin.core.config.Options;
import mcp.mobius.waila.plugin.core.renderer.Renderers;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public enum EntityComponent implements IEntityComponentProvider
{
    INSTANCE;


    @Override
    public class_1799 getDisplayItem(IEntityAccessor accessor, IPluginConfig config) {
        Object entity = accessor.getEntity();
        if (entity instanceof class_1308) {
            return class_1799.field_8037;
        }
        class_1799 stack = entity.method_31480();
        return stack != null ? stack : class_1799.field_8037;
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Object entity = accessor.getEntity();
        IWailaConfig.Formatting formatting = IWailaConfig.get().getFormatting();
        tooltip.set(WailaConstants.OBJECT_NAME_TAG, (class_2561)new class_2585(formatting.formatEntityName(entity.method_5476().getString())));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.set(WailaConstants.REGISTRY_NAME_TAG, (class_2561)new class_2585(formatting.formatRegistryName(class_2378.field_11145.method_10221((Object)entity.method_5864()))));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Object t;
        if (config.getBoolean(Options.ENTITY_HEALTH) && (t = accessor.getEntity()) instanceof class_1309) {
            class_1309 living = (class_1309)t;
            float health = living.method_6032();
            float maxHealth = living.method_6063();
            if (living.method_6063() > (float)IWailaConfig.get().getGeneral().getMaxHealthForRender()) {
                tooltip.add((class_2561)new class_2588("tooltip.waila.health", new Object[]{String.format("%.2f", Float.valueOf(health)), String.format("%.2f", Float.valueOf(maxHealth))}));
            } else {
                class_2487 healthData = new class_2487();
                healthData.method_10548("health", health / 2.0f);
                healthData.method_10548("max", maxHealth / 2.0f);
                tooltip.addDrawable(Renderers.RENDER_ENTITY_HEALTH, healthData);
            }
        }
    }

    @Override
    public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            tooltip.set(WailaConstants.MOD_NAME_TAG, (class_2561)new class_2585(IWailaConfig.get().getFormatting().formatModName(IModInfo.get(accessor.getEntity()).getName())));
        }
    }
}

