/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.badpackets.impl.handler;

import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lol.bai.badpackets.api.PacketSender;
import lol.bai.badpackets.impl.Constants;
import lol.bai.badpackets.impl.registry.ChannelRegistry;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPacketHandler<T>
implements PacketSender {
    protected final ChannelRegistry<T> registry;
    protected final Logger logger;
    private final BiFunction<class_2960, class_2540, class_2596<?>> packetFactory;
    private final Set<class_2960> sendableChannels = new HashSet<class_2960>();
    private final class_2535 connection;
    private boolean initialized = false;

    protected AbstractPacketHandler(String desc, ChannelRegistry<T> registry, BiFunction<class_2960, class_2540, class_2596<?>> packetFactory, class_2535 connection) {
        this.logger = LogManager.getLogger((String)desc);
        this.registry = registry;
        this.packetFactory = packetFactory;
        this.connection = connection;
        registry.addHandler(this);
    }

    private void receiveChannelSyncPacket(class_2540 buf) {
        switch (buf.readByte()) {
            case 0: {
                this.sendableChannels.add(buf.method_10810());
                break;
            }
            case 1: {
                int groupSize = buf.method_10816();
                for (int i = 0; i < groupSize; ++i) {
                    String namespace = buf.method_19772();
                    int pathSize = buf.method_10816();
                    for (int j = 0; j < pathSize; ++j) {
                        String path = buf.method_19772();
                        this.sendableChannels.add(new class_2960(namespace, path));
                    }
                }
                this.onInitialChannelSyncPacketReceived();
            }
        }
    }

    public boolean receive(class_2960 id, class_2540 buf) {
        if (id.equals((Object)Constants.CHANNEL_SYNC)) {
            this.receiveChannelSyncPacket(new class_2540(buf.slice()));
            return true;
        }
        if (this.registry.channels.containsKey(id)) {
            try {
                this.receive(this.registry.channels.get(id), new class_2540(buf.slice()));
            }
            catch (Throwable t) {
                this.logger.error("Error when receiving packet {}", (Object)id, (Object)t);
                throw t;
            }
            return true;
        }
        return false;
    }

    protected abstract void onInitialChannelSyncPacketReceived();

    protected abstract void receive(T var1, class_2540 var2);

    public void sendInitialChannelSyncPacket() {
        if (!this.initialized) {
            this.initialized = true;
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeByte(1);
            Map<String, List<class_2960>> group = this.registry.channels.keySet().stream().collect(Collectors.groupingBy(class_2960::method_12836));
            buf.method_10804(group.size());
            for (Map.Entry<String, List<class_2960>> entry : group.entrySet()) {
                buf.method_10814(entry.getKey());
                buf.method_10804(entry.getValue().size());
                for (class_2960 value : entry.getValue()) {
                    buf.method_10814(value.method_12832());
                }
            }
            this.send(Constants.CHANNEL_SYNC, buf);
        }
    }

    public void onRegister(class_2960 id, T handler) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeByte(0);
        buf.method_10812(id);
        this.send(Constants.CHANNEL_SYNC, buf);
    }

    public void onDisconnect() {
        this.registry.removeHandler(this);
    }

    @Override
    public void send(class_2960 id, class_2540 buf, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        this.connection.method_10752(this.packetFactory.apply(id, buf), callback);
    }

    @Override
    public boolean canSend(class_2960 id) {
        return this.sendableChannels.contains(id);
    }
}

