/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import java.util.function.Consumer;
import java.util.function.Predicate;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputValue<T>
extends ConfigValue<T> {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> INTEGER = s -> s.matches("[-+]?\\d*$");
    public static final Predicate<String> POSITIVE_INTEGER = s -> s.matches("\\d*$");
    public static final Predicate<String> DECIMAL = s -> s.matches("[-+]?\\d*([.]\\d*)?");
    public static final Predicate<String> POSITIVE_DECIMAL = s -> s.matches("\\d*([.]\\d*)?");
    private final Serializer<T> serializer;
    private final class_342 textField;
    private boolean valueFromTextField = false;

    public InputValue(String optionName, final T value, @Nullable T defaultValue, Consumer<T> save, Predicate<String> validator) {
        this(optionName, value, defaultValue, save, validator, new Serializer<T>(){

            @Override
            public String serialize(T t) {
                return String.valueOf(t);
            }

            @Override
            public T deserialize(String s) {
                if (value instanceof String) {
                    return s;
                }
                if (value instanceof Integer) {
                    return s.isEmpty() ? Integer.valueOf(0) : Integer.valueOf(s);
                }
                if (value instanceof Short) {
                    return s.isEmpty() ? Short.valueOf((short)0) : Short.valueOf(s);
                }
                if (value instanceof Byte) {
                    return s.isEmpty() ? Byte.valueOf((byte)0) : Byte.valueOf(s);
                }
                if (value instanceof Long) {
                    return s.isEmpty() ? Long.valueOf(0L) : Long.valueOf(s);
                }
                if (value instanceof Double) {
                    return s.isEmpty() ? Double.valueOf(0.0) : Double.valueOf(s);
                }
                if (value instanceof Float) {
                    return s.isEmpty() ? Float.valueOf(0.0f) : Float.valueOf(s);
                }
                throw new UnsupportedOperationException("Unsupported value type");
            }
        });
    }

    public InputValue(String optionName, T value, @Nullable T defaultValue, Consumer<T> save, Predicate<String> validator, Serializer<T> serializer) {
        super(optionName, value, defaultValue, save);
        this.serializer = serializer;
        this.textField = new WatchedTextfield();
        this.textField.method_1852(serializer.serialize(value));
        this.textField.method_1890(validator);
    }

    @Override
    protected void drawValue(class_4587 matrices, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.textField.method_1888(!this.serverOnly);
        this.textField.method_16872(x + width - this.textField.method_25368());
        this.textField.field_22761 = y + (height - this.textField.method_25364()) / 2;
        this.textField.method_25394(matrices, mouseX, mouseY, partialTicks);
    }

    @Override
    public class_364 getListener() {
        return this.textField;
    }

    @Override
    protected void resetValue() {
        this.textField.method_1852(this.serializer.serialize(this.defaultValue));
    }

    @Override
    private void setValue(String text) {
        this.valueFromTextField = true;
        try {
            this.setValue(this.serializer.deserialize(text));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setValue(T value) {
        super.setValue(value);
        if (!this.valueFromTextField) {
            this.textField.field_2092 = this.serializer.serialize(value);
            this.textField.method_1875(this.textField.field_2092.length());
            this.textField.method_1884(this.textField.method_1881());
        }
        this.valueFromTextField = false;
    }

    public static interface Serializer<T> {
        public String serialize(T var1);

        public T deserialize(String var1);
    }

    private class WatchedTextfield
    extends class_342 {
        public WatchedTextfield() {
            super(((InputValue)InputValue.this).client.field_1772, 0, 0, 160, 18, (class_2561)class_2561.method_43473());
            this.method_1863(InputValue.this::setValue);
        }

        public void method_1867(@NotNull String string) {
            String string3;
            String string2;
            int l;
            int i = Math.min(this.method_1881(), this.field_2101);
            int j = Math.max(this.method_1881(), this.field_2101);
            int k = this.field_2108 - this.method_1882().length() - (i - j);
            if (k < (l = (string2 = string).length())) {
                string2 = string2.substring(0, k);
                l = k;
            }
            if (this.field_2104.test(string3 = new StringBuilder(this.method_1882()).replace(i, j, string2).toString())) {
                this.field_2092 = string3;
                this.method_1875(i + l);
                this.method_1884(this.method_1881());
                this.method_1874(string3);
            }
        }
    }
}

