/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import java.util.List;
import java.util.function.BiFunction;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IDrawableText;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.screen.HomeConfigScreen;
import mcp.mobius.waila.hud.ClientTickHandler;
import mcp.mobius.waila.hud.component.DrawableComponent;
import mcp.mobius.waila.impl.Impl;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.CommonUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;

public abstract class WailaClient {
    public static KeyMapping openConfig;
    public static KeyMapping showOverlay;
    public static KeyMapping toggleLiquid;
    public static KeyMapping showRecipeInput;
    public static KeyMapping showRecipeOutput;
    public static Runnable onShowRecipeInput;
    public static Runnable onShowRecipeOutput;
    protected static BiFunction<String, Integer, KeyMapping> keyBindingBuilder;

    protected static void init() {
        openConfig = keyBindingBuilder.apply("config", 320);
        showOverlay = keyBindingBuilder.apply("show_overlay", 321);
        toggleLiquid = keyBindingBuilder.apply("toggle_liquid", 322);
        showRecipeInput = keyBindingBuilder.apply("show_recipe_input", 323);
        showRecipeOutput = keyBindingBuilder.apply("show_recipe_output", 324);
    }

    protected static void onJoinServer() {
        if (!Waila.packet.isServerAvailable()) {
            CommonUtil.LOGGER.warn("WTHIT is not found on the server, all syncable config will reset to their default value.");
            PluginConfig.INSTANCE.getSyncableConfigs().forEach(config -> config.setValue(config.getDefaultValue()));
        }
    }

    protected static void onClientTick() {
        Minecraft client = Minecraft.m_91087_();
        WailaConfig config = Waila.config.get();
        ClientTickHandler.tick();
        while (openConfig.m_90859_()) {
            client.m_91152_((Screen)new HomeConfigScreen(null));
        }
        while (showOverlay.m_90859_()) {
            if (config.getGeneral().getDisplayMode() != IWailaConfig.General.DisplayMode.TOGGLE) continue;
            config.getGeneral().setDisplayTooltip(!config.getGeneral().isDisplayTooltip());
        }
        while (toggleLiquid.m_90859_()) {
            PluginConfig.INSTANCE.set(WailaConstants.CONFIG_SHOW_FLUID, !PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_FLUID));
        }
        while (showRecipeInput.m_90859_() && onShowRecipeInput != null) {
            onShowRecipeInput.run();
        }
        while (showRecipeOutput.m_90859_() && onShowRecipeOutput != null) {
            onShowRecipeOutput.run();
        }
    }

    protected static void onItemTooltip(ItemStack stack, List<Component> tooltip) {
        if (PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                String name = listener.getHoveredItemModName(stack, PluginConfig.INSTANCE);
                if (name == null) continue;
                tooltip.add((Component)new TextComponent(IWailaConfig.get().getFormatting().formatModName(name)));
                return;
            }
        }
    }

    static {
        Impl.reg(IDrawableText.class, DrawableComponent::new);
    }
}

