/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.debug;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.plugin.PluginLoader;
import mcp.mobius.waila.registry.Register;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.CommonUtil;
import net.minecraft.resources.ResourceLocation;

public class DumpGenerator {
    public static final Map<String, String> VERSIONS = new LinkedHashMap<String, String>();

    public static boolean generate(Path path) {
        boolean bl;
        StringBuilder builder = new StringBuilder("# Waila Dump");
        Registrar registrar = Registrar.INSTANCE;
        builder.append("\n## Versions");
        builder.append("\n| Dependency | Version |");
        builder.append("\n| - | - |");
        VERSIONS.forEach((k, v) -> builder.append("\n| ").append((String)k).append(" | `").append((String)v).append("` |"));
        builder.append("\n## Plugins");
        builder.append("\n| Plugin ID | Plugin Class |");
        builder.append("\n| - | - |");
        PluginLoader.PLUGINS.keySet().stream().sorted(ResourceLocation::compareTo).forEachOrdered(id -> builder.append("\n| `").append(id).append("` | `").append(PluginLoader.PLUGINS.get(id).getClass().getCanonicalName()).append("` |"));
        builder.append("\n## Block");
        DumpGenerator.createSection(builder, "Override Providers", registrar.blockOverride);
        DumpGenerator.createSection(builder, "Display Item Providers", registrar.entityItem);
        DumpGenerator.createSection(builder, "Head Providers", registrar.entityComponent.get((Object)TooltipPosition.HEAD));
        DumpGenerator.createSection(builder, "Body Providers", registrar.entityComponent.get((Object)TooltipPosition.BODY));
        DumpGenerator.createSection(builder, "Tail Providers", registrar.entityComponent.get((Object)TooltipPosition.TAIL));
        DumpGenerator.createSection(builder, "Data Providers", registrar.blockData);
        builder.append("\n## Entity");
        DumpGenerator.createSection(builder, "Override Providers", registrar.entityOverride);
        DumpGenerator.createSection(builder, "Display Item Providers", registrar.entityItem);
        DumpGenerator.createSection(builder, "Head Providers", registrar.entityComponent.get((Object)TooltipPosition.HEAD));
        DumpGenerator.createSection(builder, "Body Providers", registrar.entityComponent.get((Object)TooltipPosition.BODY));
        DumpGenerator.createSection(builder, "Tail Providers", registrar.entityComponent.get((Object)TooltipPosition.TAIL));
        DumpGenerator.createSection(builder, "Data Providers", registrar.entityData);
        FileWriter writer = new FileWriter(path.toFile());
        try {
            writer.write(builder.toString());
            CommonUtil.LOGGER.info("Created debug dump at {}", (Object)path);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        writer.close();
        return bl;
    }

    private static <T> void createSection(StringBuilder builder, String subsection, Register<T> registry) {
        Map<Class<?>, List<Register.Entry<T>>> map = registry.getMap();
        if (map.isEmpty()) {
            return;
        }
        builder.append("\n### ").append(subsection);
        builder.append("\n| Target Class | Provider Class |");
        builder.append("\n| - | - |");
        map.forEach((k, v) -> {
            if (!v.isEmpty()) {
                builder.append("\n| `").append(k.getName()).append("` ");
                int[] i = new int[]{0};
                v.stream().map(o -> o.value().getClass().getName()).distinct().sorted(String::compareToIgnoreCase).forEachOrdered(s -> {
                    if (i[0] == 0) {
                        builder.append("| `").append((String)s).append("` |");
                    } else {
                        builder.append("\n| | `").append((String)s).append("` |");
                    }
                    i[0] = i[0] + 1;
                });
            }
        });
        builder.append("\n\n");
    }
}

