/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.forge;

import com.mojang.blaze3d.platform.InputConstants;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.gui.screen.HomeConfigScreen;
import mcp.mobius.waila.hud.TooltipHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fmlclient.ConfigGuiHandler;
import net.minecraftforge.fmlclient.registry.ClientRegistry;

@Mod.EventBusSubscriber(modid="waila", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeWailaClient
extends WailaClient {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        keyBindingBuilder = (id, key) -> {
            KeyMapping keyBinding = new KeyMapping("key.waila." + id, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, key.intValue(), "WTHIT");
            ClientRegistry.registerKeyBinding((KeyMapping)keyBinding);
            return keyBinding;
        };
        ForgeWailaClient.init();
        ForgeWailaClient.registerConfigScreen();
    }

    static void registerConfigScreen() {
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, screen) -> new HomeConfigScreen((Screen)screen)));
    }

    @Mod(value="wthit")
    @Mod.EventBusSubscriber(modid="wthit", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class HahaBorgeGoBrrrr {
        @SubscribeEvent
        static void clientSetup(FMLClientSetupEvent event) {
            ForgeWailaClient.registerConfigScreen();
        }
    }

    @Mod.EventBusSubscriber(modid="waila", value={Dist.CLIENT})
    static class Subscriber {
        Subscriber() {
        }

        @SubscribeEvent
        static void entityJoinWorld(EntityJoinWorldEvent event) {
            if (event.getEntity() instanceof LocalPlayer) {
                ForgeWailaClient.onJoinServer();
            }
        }

        @SubscribeEvent
        static void renderGameOverlay(RenderGameOverlayEvent.Post event) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                TooltipHandler.render(event.getMatrixStack(), event.getPartialTicks());
            }
        }

        @SubscribeEvent
        static void clientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                ForgeWailaClient.onClientTick();
            }
        }

        @SubscribeEvent
        static void itemTooltip(ItemTooltipEvent event) {
            ForgeWailaClient.onItemTooltip(event.getItemStack(), event.getToolTip());
        }
    }
}

