/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.widget.ButtonEntry;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.BooleanValue;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.gui.widget.value.EnumValue;
import mcp.mobius.waila.gui.widget.value.InputValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class PluginConfigScreen
extends ConfigScreen {
    private static final String NO_CATEGORY = "no_category";
    private static final Map<ConfigEntry.Type<Object>, ConfigValueFunction<Object>> ENTRY_TO_VALUE = new HashMap<ConfigEntry.Type<Object>, ConfigValueFunction<Object>>();

    public PluginConfigScreen(Screen parent) {
        super(parent, (Component)new TranslatableComponent("gui.waila.plugin_settings"), PluginConfig.INSTANCE::save, PluginConfig.INSTANCE::reload);
    }

    private static <T> void register(ConfigEntry.Type<T> type, ConfigValueFunction<T> function) {
        ENTRY_TO_VALUE.put(type, function);
    }

    @Override
    public ConfigListWidget getOptions() {
        ConfigListWidget options = new ConfigListWidget(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 26, PluginConfig.INSTANCE::save);
        for (String namespace : PluginConfig.INSTANCE.getNamespaces()) {
            final String translationKey = "config.waila.plugin_" + namespace;
            final Set<ResourceLocation> keys = PluginConfig.INSTANCE.getKeys(namespace);
            options.with(new ButtonEntry(translationKey, 100, 20, w -> this.f_96541_.m_91152_((Screen)new ConfigScreen(this, (Component)new TranslatableComponent(translationKey)){

                @Override
                public ConfigListWidget getOptions() {
                    ConfigListWidget options = new ConfigListWidget(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 26);
                    Object2IntLinkedOpenHashMap categories = new Object2IntLinkedOpenHashMap();
                    categories.put((Object)PluginConfigScreen.NO_CATEGORY, 0);
                    for (ResourceLocation key : keys) {
                        String c;
                        String translation;
                        ConfigEntry entry = PluginConfig.INSTANCE.getEntry(key);
                        if (entry.isSynced() && Minecraft.m_91087_().m_91089_() != null) continue;
                        String path = key.m_135815_();
                        String category = PluginConfigScreen.NO_CATEGORY;
                        if (path.contains(".") && I18n.m_118936_((String)(translation = translationKey + "." + (c = path.split("[.]", 2)[0]))) && !categories.containsKey((Object)(category = c))) {
                            options.with(new CategoryEntry(translation));
                            categories.put((Object)category, options.m_6702_().size());
                        }
                        int index = categories.getInt((Object)category);
                        for (Object2IntMap.Entry e : categories.object2IntEntrySet()) {
                            if (e.getIntValue() < index) continue;
                            e.setValue(e.getIntValue() + 1);
                        }
                        options.with(index, ENTRY_TO_VALUE.get(entry.getType()).create(translationKey + "." + path, entry.getValue(), entry.getDefaultValue(), entry::setValue));
                    }
                    return options;
                }
            })));
        }
        return options;
    }

    static {
        PluginConfigScreen.register(ConfigEntry.BOOLEAN, BooleanValue::new);
        PluginConfigScreen.register(ConfigEntry.INTEGER, (name, value, defaultValue, save) -> new InputValue<Integer>(name, (Integer)value, (Integer)defaultValue, save, InputValue.INTEGER));
        PluginConfigScreen.register(ConfigEntry.DOUBLE, (name, value, defaultValue, save) -> new InputValue<Double>(name, (Double)value, (Double)defaultValue, save, InputValue.DECIMAL));
        PluginConfigScreen.register(ConfigEntry.STRING, (name, value, defaultValue, save) -> new InputValue<String>(name, (String)value, (String)defaultValue, save, InputValue.ANY));
        PluginConfigScreen.register(ConfigEntry.ENUM, (name, value, defaultValue, save) -> new EnumValue(name, (Enum[])value.getDeclaringClass().getEnumConstants(), value, defaultValue, save));
    }

    @FunctionalInterface
    private static interface ConfigValueFunction<T> {
        public ConfigValue<T> create(String var1, T var2, T var3, Consumer<T> var4);
    }
}

