/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.hud;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.data.DataAccessor;
import mcp.mobius.waila.hud.Tooltip;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.ExceptionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ComponentHandler {
    public static void gatherBlock(DataAccessor accessor, Tooltip tooltip, TooltipPosition position) {
        Registrar registrar = Registrar.INSTANCE;
        Block block = accessor.getBlock();
        Object blockEntity = accessor.getBlockEntity();
        int rate = Waila.config.get().getGeneral().getRateLimit();
        if (blockEntity != null && accessor.isTimeElapsed(rate) && Waila.config.get().getGeneral().isDisplayTooltip()) {
            accessor.resetTimer();
            if (!registrar.blockData.get(block).isEmpty() || !registrar.blockData.get(blockEntity).isEmpty()) {
                Waila.packet.requestBlock((BlockEntity)blockEntity);
            }
        }
        ComponentHandler.handleBlock(accessor, tooltip, block, position);
        ComponentHandler.handleBlock(accessor, tooltip, blockEntity, position);
    }

    private static void handleBlock(DataAccessor accessor, Tooltip tooltip, Object obj, TooltipPosition position) {
        Registrar registrar = Registrar.INSTANCE;
        List<IBlockComponentProvider> providers = registrar.blockComponent.get((Object)position).get(obj);
        for (IBlockComponentProvider provider : providers) {
            try {
                switch (position) {
                    case HEAD: {
                        provider.appendHead(tooltip, (IBlockAccessor)accessor, (IPluginConfig)PluginConfig.INSTANCE);
                        provider.appendHead(tooltip, (IBlockAccessor)accessor, (IPluginConfig)PluginConfig.INSTANCE);
                        break;
                    }
                    case BODY: {
                        provider.appendBody(tooltip, (IBlockAccessor)accessor, (IPluginConfig)PluginConfig.INSTANCE);
                        provider.appendBody(tooltip, (IBlockAccessor)accessor, (IPluginConfig)PluginConfig.INSTANCE);
                        break;
                    }
                    case TAIL: {
                        provider.appendTail(tooltip, (IBlockAccessor)accessor, (IPluginConfig)PluginConfig.INSTANCE);
                        provider.appendTail(tooltip, (IBlockAccessor)accessor, (IPluginConfig)PluginConfig.INSTANCE);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionUtil.dump(e, provider.getClass().toString(), tooltip);
            }
        }
    }

    public static void gatherEntity(Entity entity, DataAccessor accessor, Tooltip tooltip, TooltipPosition position) {
        Registrar registrar = Registrar.INSTANCE;
        Object trueEntity = accessor.getEntity();
        int rate = Waila.config.get().getGeneral().getRateLimit();
        if (trueEntity != null && accessor.isTimeElapsed(rate)) {
            accessor.resetTimer();
            if (!registrar.entityData.get(trueEntity).isEmpty()) {
                Waila.packet.requestEntity((Entity)trueEntity);
            }
        }
        List<IEntityComponentProvider> providers = registrar.entityComponent.get((Object)position).get(entity);
        for (IEntityComponentProvider provider : providers) {
            try {
                switch (position) {
                    case HEAD: {
                        provider.appendHead(tooltip, (IEntityAccessor)accessor, (IPluginConfig)PluginConfig.INSTANCE);
                        provider.appendHead(tooltip, (IEntityAccessor)accessor, (IPluginConfig)PluginConfig.INSTANCE);
                        break;
                    }
                    case BODY: {
                        provider.appendBody(tooltip, (IEntityAccessor)accessor, (IPluginConfig)PluginConfig.INSTANCE);
                        provider.appendBody(tooltip, (IEntityAccessor)accessor, (IPluginConfig)PluginConfig.INSTANCE);
                        break;
                    }
                    case TAIL: {
                        provider.appendTail(tooltip, (IEntityAccessor)accessor, (IPluginConfig)PluginConfig.INSTANCE);
                        provider.appendTail(tooltip, (IEntityAccessor)accessor, (IPluginConfig)PluginConfig.INSTANCE);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionUtil.dump(e, provider.getClass().toString(), tooltip);
            }
        }
    }

    public static ItemStack getDisplayItem(HitResult target) {
        block5: {
            PluginConfig config;
            DataAccessor data;
            Registrar registrar;
            block4: {
                registrar = Registrar.INSTANCE;
                data = DataAccessor.INSTANCE;
                config = PluginConfig.INSTANCE;
                if (target.m_6662_() != HitResult.Type.ENTITY) break block4;
                List<IEntityComponentProvider> providers = registrar.entityItem.get(data.getEntity());
                for (IEntityComponentProvider provider : providers) {
                    ItemStack providerStack = provider.getDisplayItem(data, config);
                    if (providerStack.m_41619_()) continue;
                    return providerStack;
                }
                break block5;
            }
            BlockState state = data.getBlockState();
            if (state.m_60795_()) {
                return ItemStack.f_41583_;
            }
            List<IBlockComponentProvider> providers = registrar.blockItem.get(state.m_60734_());
            for (IBlockComponentProvider provider : providers) {
                ItemStack providerStack = provider.getDisplayItem(data, config);
                if (providerStack.m_41619_()) continue;
                return providerStack;
            }
            Object blockEntity = data.getBlockEntity();
            if (blockEntity == null) break block5;
            providers = registrar.blockItem.get(blockEntity);
            for (IBlockComponentProvider provider : providers) {
                ItemStack providerStack = provider.getDisplayItem(data, config);
                if (providerStack.m_41619_()) continue;
                return providerStack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static Entity getOverrideEntity(HitResult target) {
        if (target == null || target.m_6662_() != HitResult.Type.ENTITY) {
            return null;
        }
        Registrar registrar = Registrar.INSTANCE;
        Entity entity = ((EntityHitResult)target).m_82443_();
        List<IEntityComponentProvider> overrideProviders = registrar.entityOverride.get(entity);
        for (IEntityComponentProvider provider : overrideProviders) {
            Entity override = provider.getOverride(DataAccessor.INSTANCE, PluginConfig.INSTANCE);
            if (override == null) continue;
            return override;
        }
        return entity;
    }

    public static BlockState getOverrideBlock(HitResult target) {
        Registrar registrar = Registrar.INSTANCE;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        BlockPos pos = ((BlockHitResult)target).m_82425_();
        BlockState state = world.m_8055_(pos);
        List<IBlockComponentProvider> providers = registrar.blockOverride.get(state.m_60734_());
        for (IBlockComponentProvider provider : providers) {
            BlockState override = provider.getOverride(DataAccessor.INSTANCE, PluginConfig.INSTANCE);
            if (override == null) continue;
            return override;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        providers = registrar.blockOverride.get(blockEntity);
        for (IBlockComponentProvider provider : providers) {
            BlockState override = provider.getOverride(DataAccessor.INSTANCE, PluginConfig.INSTANCE);
            if (override == null) continue;
            return override;
        }
        return state;
    }
}

