/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.hud;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IDrawableComponent;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.hud.component.DrawableComponent;
import mcp.mobius.waila.hud.component.PairComponent;
import mcp.mobius.waila.hud.component.TaggedComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class Tooltip
extends ObjectArrayList<Component>
implements ITooltip,
ITaggableList<ResourceLocation, Component> {
    private final Object2IntMap<ResourceLocation> tags = new Object2IntOpenHashMap();

    @Override
    public void addPair(Component key, Component value) {
        this.add(new PairComponent(key, value));
    }

    @Override
    public IDrawableComponent addDrawable() {
        DrawableComponent component = new DrawableComponent();
        this.add(component);
        return component;
    }

    @Override
    public IDrawableComponent addDrawable(ResourceLocation id, CompoundTag data) {
        return this.addDrawable().with(id, data);
    }

    @Override
    public void set(ResourceLocation tag, Component component) {
        TaggedComponent tagged = new TaggedComponent(tag, component);
        if (this.tags.containsKey((Object)tag)) {
            this.set(this.tags.getInt((Object)tag), tagged);
        } else {
            this.tags.put((Object)tag, this.size);
            this.add(tagged);
        }
    }

    @Override
    public void setTag(ResourceLocation tag, Component value) {
        this.set(tag, value);
    }

    @Override
    public Component removeTag(ResourceLocation tag) {
        return this.tags.containsKey((Object)tag) ? (Component)this.remove(this.tags.removeInt((Object)tag)) : null;
    }

    @Override
    public Component getTag(ResourceLocation tag) {
        return this.tags.containsKey((Object)tag) ? (Component)this.get(this.tags.getInt((Object)tag)) : null;
    }

    @Override
    public Map<ResourceLocation, Component> getTags() {
        return this.tags.object2IntEntrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Component)this.get(e.getIntValue())));
    }

    @Override
    public void absorb(ITaggableList<ResourceLocation, Component> other) {
    }

    @Override
    public void clear() {
        super.clear();
        this.tags.clear();
    }

    @Nullable
    public Component get(ResourceLocation tag) {
        return this.tags.containsKey((Object)tag) ? ((TaggedComponent)this.get((int)this.tags.getInt((Object)tag))).value : null;
    }
}

