/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.CommonUtil;
import net.minecraft.resources.ResourceLocation;

public abstract class PluginLoader {
    public static final Map<ResourceLocation, IWailaPlugin> PLUGINS = new Object2ObjectOpenHashMap();

    protected static void createPlugin(String id, String initializer) {
        try {
            IWailaPlugin plugin = (IWailaPlugin)Class.forName(initializer).getConstructor(new Class[0]).newInstance(new Object[0]);
            PLUGINS.put(new ResourceLocation(id), plugin);
            CommonUtil.LOGGER.info("Discovered plugin {} at {}", (Object)id, (Object)plugin.getClass().getCanonicalName());
        }
        catch (Throwable t) {
            CommonUtil.LOGGER.error("Error creating instance of plugin " + id, t);
        }
    }

    private static boolean isWailaClass(Object object) {
        return object.getClass().getCanonicalName().startsWith("mcp/mobius/waila");
    }

    protected abstract void gatherPlugins();

    public void initialize() {
        PLUGINS.clear();
        this.gatherPlugins();
        if (Boolean.getBoolean("waila.enableTestPlugin")) {
            PluginLoader.createPlugin("waila:test", "mcp.mobius.waila.plugin.test.WailaTest");
        }
        ArrayList sorted = Lists.newArrayList(PLUGINS.values());
        sorted.sort((o1, o2) -> {
            if (PluginLoader.isWailaClass(o1) && PluginLoader.isWailaClass(o2)) {
                return 0;
            }
            if (PluginLoader.isWailaClass(o1)) {
                return -1;
            }
            return o1.getClass().getCanonicalName().compareToIgnoreCase(o2.getClass().getCanonicalName());
        });
        sorted.forEach(p -> {
            CommonUtil.LOGGER.info("Registering plugin at {}", (Object)p.getClass().getCanonicalName());
            p.register(Registrar.INSTANCE);
        });
        Registrar.INSTANCE.lock();
        PluginConfig.INSTANCE.reload();
    }
}

