/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.component;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.plugin.core.config.Options;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;

public enum BlockComponent implements IBlockComponentProvider,
IServerDataProvider<BlockEntity>
{
    INSTANCE;


    @Override
    public ItemStack getDisplayItem(IBlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        return state.m_60734_().m_7397_((BlockGetter)accessor.getWorld(), accessor.getPosition(), state);
    }

    @Override
    public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        String name;
        if (accessor.getBlockState().m_60767_().m_76332_()) {
            return;
        }
        Block block = accessor.getBlock();
        String string = name = accessor.getBlockEntity() != null ? accessor.getServerData().m_128461_("customName") : "";
        if (name.isEmpty()) {
            name = block.m_49954_().getString();
        }
        IWailaConfig.Formatting formatting = IWailaConfig.get().getFormatting();
        tooltip.set(WailaConstants.OBJECT_NAME_TAG, (Component)new TextComponent(formatting.formatBlockName(name)));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.set(WailaConstants.REGISTRY_NAME_TAG, (Component)new TextComponent(formatting.formatRegistryName(Registry.f_122824_.m_7981_((Object)block))));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.POS)) {
            BlockPos pos = accessor.getPosition();
            tooltip.add((Component)new TextComponent("(" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + ")"));
        }
        if (config.getBoolean(Options.STATES)) {
            BlockState state = accessor.getBlockState();
            state.m_61147_().forEach(p -> {
                Comparable value = state.m_61143_(p);
                MutableComponent valueText = new TextComponent(value.toString()).m_6270_(Style.f_131099_.m_131140_(p instanceof BooleanProperty ? (value == Boolean.TRUE ? ChatFormatting.GREEN : ChatFormatting.RED) : ChatFormatting.RESET));
                tooltip.addPair((Component)new TextComponent(p.m_61708_()), (Component)valueText);
            });
        }
    }

    @Override
    public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            String modName = IWailaConfig.get().getFormatting().formatModName(IModInfo.get(accessor.getBlock()).getName());
            tooltip.set(WailaConstants.MOD_NAME_TAG, (Component)new TextComponent(modName));
        }
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity blockEntity) {
        Component name;
        if (blockEntity instanceof Nameable && (name = ((Nameable)blockEntity).m_7770_()) != null) {
            data.m_128359_("customName", name.getString());
        }
    }
}

