/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.component;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;

public enum PetOwnerComponent implements IEntityComponentProvider
{
    INSTANCE;

    static final Map<UUID, Component> NAMES;
    static final Component UNKNOWN;

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.PET_OWNER)) {
            Component name;
            Object entity = accessor.getEntity();
            UUID uuid = null;
            Object t = entity;
            if (t instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)t;
                uuid = horse.m_30615_();
            } else {
                t = entity;
                if (t instanceof OwnableEntity) {
                    OwnableEntity ownableEntity = (OwnableEntity)t;
                    uuid = ownableEntity.m_142504_();
                }
            }
            if (uuid == null) {
                return;
            }
            if (NAMES.containsKey(uuid)) {
                name = NAMES.get(uuid);
            } else {
                GameProfile profile = Minecraft.m_91087_().m_91108_().fillProfileProperties(new GameProfile(uuid, null), true);
                name = profile.getName() == null ? null : new TextComponent(profile.getName());
                NAMES.put(uuid, name);
            }
            if (name != null) {
                tooltip.addPair((Component)new TranslatableComponent("tooltip.waila.owner"), name);
            } else if (!config.getBoolean(Options.PET_HIDE_UNKNOWN_OWNER)) {
                tooltip.addPair((Component)new TranslatableComponent("tooltip.waila.owner"), UNKNOWN);
            }
        }
    }

    static {
        NAMES = new HashMap<UUID, Component>();
        UNKNOWN = new TextComponent("???");
    }
}

